% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_articles.R
\name{core_articles}
\alias{core_articles}
\alias{core_articles_}
\title{Get articles}
\usage{
core_articles(
  id,
  metadata = TRUE,
  fulltext = FALSE,
  citations = FALSE,
  similar = FALSE,
  duplicate = FALSE,
  urls = FALSE,
  extractedUrls = FALSE,
  faithfulMetadata = FALSE,
  key = NULL,
  method = "GET",
  parse = TRUE,
  ...
)

core_articles_(
  id,
  metadata = TRUE,
  fulltext = FALSE,
  citations = FALSE,
  similar = FALSE,
  duplicate = FALSE,
  urls = FALSE,
  extractedUrls = FALSE,
  faithfulMetadata = FALSE,
  key = NULL,
  method = "GET",
  ...
)
}
\arguments{
\item{id}{(integer) CORE ID of the article that needs to be fetched.
Required}

\item{metadata}{Whether to retrieve the full article metadata or only the
ID. Default: \code{TRUE}}

\item{fulltext}{Whether to retrieve full text of the article. Default:
\code{FALSE}}

\item{citations}{Whether to retrieve citations found in the article.
Default: \code{FALSE}}

\item{similar}{Whether to retrieve a list of similar articles.
Default: \code{FALSE}
Because the similar articles are calculated on demand, setting this
parameter to true might slightly slow down the response time    query}

\item{duplicate}{Whether to retrieve a list of CORE IDs of different
versions of the article. Default: \code{FALSE}}

\item{urls}{Whether to retrieve a list of URLs from which the article can
be downloaded. This can include links to PDFs as well as HTML pages.
Default: \code{FALSE}}

\item{extractedUrls}{Whether to retrieve a list of URLs which were extracted
from the article fulltext. Default: \code{FALSE}. This parameter is not
available in CORE API v2.0 beta}

\item{faithfulMetadata}{Whether to retrieve the raw XML metadata of the
article. Default: \code{FALSE}}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{method}{(character) one of 'GET' (default) or 'POST'}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\description{
Get articles
}
\details{
\code{core_articles} does the HTTP request and parses, while
\code{core_articles_} just does the HTTP request, gives back JSON as a
character string

These functions take one article ID at a time. Use lapply/loops/etc for
many ids
}
\examples{
\dontrun{
core_articles(id = 21132995)
core_articles(id = 21132995, fulltext = TRUE)
core_articles(id = 21132995, citations = TRUE)

# when passing >1 article ID
ids <- c(20955435, 21132995, 21813171, 22815670, 23828884,
   23465055, 23831838, 23923390, 22559733)
## you can use method="GET" with lapply or similar
res <- lapply(ids, core_articles)
vapply(res, "[[", "", c("data", "datePublished"))

## or use method="POST" passing all at once
res <- core_articles(ids, method = "POST")
head(res$data)
res$data$authors

# just http request, get text back
core_articles_(id = '21132995')
## POST, can pass many at once
core_articles_(id = ids, method = "POST")
}
}
\references{
\url{https://core.ac.uk/docs/#!/articles/getArticleByCoreIdBatch}
\url{https://core.ac.uk/docs/#!/articles/getArticleByCoreId}
}
