% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_valrng}
\alias{ddi_valrng}
\alias{ddi_invalrng}
\alias{ddi_item}
\alias{ddi_key}
\title{valrng, invalrng, and their child nodes}
\usage{
ddi_valrng(...)

ddi_invalrng(...)

ddi_item(...)

ddi_key(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Values for a particular variable that represent legitimate responses
(valrng) or illegitamate response (invalrng). Must include item or range as
a child element.
}
\details{
\emph{Parent nodes}

\code{valrng} and \code{invalrng} are contained in \code{var}.

\emph{valrng and invalrng specific child nodes}

\code{ddi_item()} is the counterpart to range; used to encode individual values.
This is an empty element consisting only of its attributes. The "UNITS"
attribute permits the specification of integer/real numbers. The "VALUE"
attribute specifies the actual value.

\code{ddi_key()} is the range key. This element permits a listing of the category
values and labels. While this information is coded separately in the Category
element, there may be some value in having this information in proximity to
the range of valid and invalid values. A table is permissible in this element.
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_notes]{ddi_notes()}}
\item \code{\link[=ddi_range]{ddi_range()}}
}
}

\examples{
# ddi_valrng() and ddi_invalrng() requires either the ddi_item() or ddi_range() child node.

ddi_valrng(ddi_item())

ddi_invalrng(ddi_item())

ddi_valrng(ddi_range())

ddi_invalrng(ddi_range())

# Functions that must be wrapped in ddi_valrng() or ddi_invalrng()

ddi_item(VALUE = "1")

ddi_key("05 (PSU) Parti Socialiste Unifie et extreme gauche (Lutte Ouvriere) 
        [United Socialists and extreme left (Workers Struggle)] 50 Les Verts 
        [Green Party] 80 (FN) Front National et extreme droite [National Front 
        and extreme right]")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/valrng.html}{valrng documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/invalrng.html}{invalrng documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/item.html}{item documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/key.html}{key documentation}
}
