% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukair_catalogue.R
\name{ukair_catalogue}
\alias{ukair_catalogue}
\title{Get DEFRA UK-AIR stations metadata}
\usage{
ukair_catalogue(
  site_name = "",
  pollutant = 9999,
  group_id = 9999,
  closed = "true",
  country_id = 9999,
  region_id = 9999
)
}
\arguments{
\item{site_name}{This is the name of a specific site. By default this is left
blank to get info on all the available sites.}

\item{pollutant}{This is a number from 1 to 10. Default is 9999, which means
all the pollutants.}

\item{group_id}{This is the identification number of a group of stations.
Default is 9999 which means all available networks.}

\item{closed}{This is "true" to include closed stations, "false" otherwise.}

\item{country_id}{This is the identification number of the country, it can be
a number from 1 to 6. Default is 9999, which means all the countries.}

\item{region_id}{This is the identification number of the region. 1 =
Aberdeen City, etc. (for the full list see
\url{https://uk-air.defra.gov.uk/}). Default is 9999, which means all the
local authorities.}
}
\value{
A dataframe listing stations and related information.
}
\description{
This function fetches the catalogue of monitoring stations from
DEFRA's website.
}
\details{
The argument \code{Pollutant} is defined based on the following convention:
\itemize{
 \item{1 = Ozone (O3)}
 \item{2 = Nitrogen oxides (NOx)}
 \item{3 = Carbon monoxide (CO)}
 \item{4 = Sulphur dioxide (SO2)}
 \item{5 = Particulate Matter (PM10)}
 \item{6 = Particulate Matter (PM2.5)}
 \item{7 = PAHs}
 \item{8 = Metals in PM10}
 \item{9 = Benzene}
 \item{10 = Black Carbon}
}

The argument \code{group_id} is defined based on the following convention:
\itemize{
 \item{1 = UKEAP: Precip-Net}
 \item{2 = Air Quality Strategy Pollutants}
 \item{3 = Ammonia and Nitric Acid}
 \item{4 = Automatic Urban and Rural Monitoring Network (AURN)}
 \item{5 = Dioxins and Furans}
 \item{6 = Black Smoke & SO2}
 \item{7 = Automatic Hydrocarbon Network}
 \item{8 = Heavy Metals}
 \item{9 = Nitrogen Dioxide Diffusion Tube}
 \item{10 = PAH Andersen}
 \item{11 = Particle Size Composition}
 \item{12 = PCBs}
 \item{13 = TOMPs}
 \item{14 = Non-Automatic Hydrocarbon Network}
 \item{15 = 1,3-Butadiene Diffusion Tube}
 \item{16 = Black Carbon}
 \item{17 = Automatic Urban and Rural Monitoring Network (AURN)}
 \item{18 = Defra NO2 Diffusion Tube}
 \item{19 = PAH Digitel (solid phase)}
 \item{20 = PAH Digitel (solid+vapour)}
 \item{21 = PAH Deposition}
 \item{22 = Particle size and number}
 \item{23 = Rural Automatic Mercury network}
 \item{24 = Urban Sulphate}
 \item{25 = UKEAP: Rural NO2}
 \item{26 = Automatic Urban and Rural Monitoring Network (AURN)}
 \item{27 = UKEAP: National Ammonia Monitoring Network}
 \item{28 = UKEAP: Acid Gases & Aerosol Network}
 \item{29 = Particle Speciation (MARGA)}
 \item{30 = UKEAP: Historic Aerosol measurements}
}

The argument \code{country_id} is defined based on the following convention:
\itemize{
 \item{1 = England}
 \item{2 = Wales}
 \item{3 = Scotland}
 \item{4 = Northern Ireland}
 \item{5 = Republic of Ireland}
 \item{6 = Channel Islands}
 }
}
\examples{
 \dontrun{
 stations <- ukair_catalogue()
 }

}
