% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProductService.R
\name{dfp_getProductsByStatement}
\alias{dfp_getProductsByStatement}
\title{getProductsByStatement}
\usage{
dfp_getProductsByStatement(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getProductsByStatementResponse
}
\description{
Gets a ProductPage of Product objects that satisfy the criteria specified by given Statement query.  When using sales management, the following fields are supported for filtering and/or sorting.  
\itemize{
  \item{rateCardId}
  \item{status}
  \item{lineItemType}
  \item{productType}
  \item{rateType}
  \item{productTemplateId}
  \item{name}
  \item{description}
  \item{id}
  \item{lastModifiedDateTime}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getProductsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/doubleclick-publishers/docs/reference/v201802/ProductService#getProductsByStatement}{Google Documentation for getProductsByStatement}
}
