% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity-measures.R
\name{raw_sub_beta}
\alias{raw_sub_beta}
\title{Raw subcommunity beta diversity}
\usage{
raw_sub_beta(meta, qs)
}
\arguments{
\item{meta}{object of class \code{metacommunity}}

\item{qs}{\code{vector} of \emph{q} values}
}
\value{
Returns a standard output of class \code{tibble}, with columns:
\code{measure}, (raw beta),
\code{q} (parameter of conservatism), 
\code{type_level} (), 
\code{type_name} (label attributed to type), 
\code{partition_level} (level of diversity, \emph{i.e.} subcommunity), 
\code{partition_name} (label attributed to partition), and 
\code{diversity}.
}
\description{
Calculates similarity-sensitive raw subcommunity beta diversity (the 
distinctiveness of subcommunity \emph{j}). This measure may be calculated 
for a series of orders, repesented as a vector of \code{qs}.
}
\examples{
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate raw subcommunity beta diversity
raw_sub_beta(meta, 0:2)

}
\references{
Reeve, R., T. Leinster, C. Cobbold, J. Thompson, N. Brummitt, 
S. Mitchell, and L. Matthews. 2014. How to partition diversity. 
arXiv 1404.6520:1–9.
}
