% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_file_ops.R
\name{drop_exists}
\alias{drop_exists}
\title{Checks to see if a file/folder exists on Dropbox}
\usage{
drop_exists(path = NULL, dtoken = get_dropbox_token())
}
\arguments{
\item{path}{The full path to a Dropbox file}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\value{
boolean; TRUE is the file or folder exists, FALSE if it does not.
}
\description{
Since many file operations such as move, copy, delete and history can only act
on files that currently exist on a Dropbox store, checking to see if the
\code{path} is valid before operating prevents bad API calls from being sent
to the server. This functions returns a logical response after checking if a
file path is valid on Dropbox.
}
\examples{
\dontrun{
  drop_create("existential_test")
  drop_exists("existential_test")
  drop_delete("existential_test")
}

}
