% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRadar.R
\name{plotRadar}
\alias{plotRadar}
\title{plot radar products on a pretty map}
\usage{
plotRadar(
  x,
  layer = NULL,
  main = "",
  land = "gray80",
  sea = "cadetblue1",
  de = "grey80",
  eu = "black",
  xlim = NULL,
  ylim = NULL,
  project = TRUE,
  proj = "radolan",
  extent = "radolan",
  targetproj = "ll",
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x}{raster oject, e.g. 'dat' element of object returned by \code{\link{readDWD}}.}

\item{layer}{Optional: selected layer(s) to be plotted. DEFAULT: NULL}

\item{main}{Graph title(s). DEFAULT: ""}

\item{land}{Color of land areas in the map. DEFAULT: "gray80"}

\item{sea}{Color of sea areas in the map. DEFAULT: "cadetblue1"}

\item{de}{Color of Deutschland Bundesland borders. DEFAULT: "grey80"}

\item{eu}{Color of Europe country borders. DEFAULT: "black"}

\item{xlim}{xlim. DEFAULT: NULL, i.e. taken from x extent (after reprojection if \code{project=TRUE})}

\item{ylim}{ylim. DEFAULT: NULL, i.e. taken from y extent (after reprojection if \code{project=TRUE})}

\item{project}{Project the data before plotting? Not needed if 
\code{\link{projectRasterDWD}} has already been called. DEFAULT: TRUE}

\item{proj}{current projection, see \code{\link{projectRasterDWD}}, 
used only if \code{project=TRUE}. DEFAULT: "radolan"}

\item{extent}{current extent, see \code{\link{projectRasterDWD}}, 
used only if \code{project=TRUE}. DEFAULT: "radolan"}

\item{targetproj}{target projection, see \code{\link{projectRasterDWD}}, 
used only if \code{project=TRUE}. DEFAULT: "ll"}

\item{quiet}{suppress progress messages? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{raster::\link[raster]{plot}}}
}
\value{
raster object, projected (if \code{project=TRUE}).
If \code{length(layer)==1}, only that selected layer is returned.
If \code{main} is non-empty, it is added to \code{x@title}.
}
\description{
Convenience function to plot radar products on a pretty map. 
Creates a separate plot for each layer, a selection is possible.
}
\examples{
# See homepage in the section 'See Also'
\dontrun{ ## Excluded from CRAN checks: requires internet connection
link <- "seasonal/air_temperature_mean/16_DJF/grids_germany_seasonal_air_temp_mean_188216.asc.gz"
rad <- dataDWD(link, base=gridbase, joinbf=TRUE, dir=tempdir())
plotRadar(rad, proj="seasonal", extent=rad@extent)
plotRadar(rad, ylim=c(52,54), proj="seasonal", extent=rad@extent)
plotRadar(rad)
}

}
\seealso{
\code{\link{readDWD}}, \url{https://bookdown.org/brry/rdwd/raster-data.html}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Feb 2020
}
\keyword{aplot}
\keyword{spatial}
