% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotEvents}
\alias{plotEvents}
\title{Produce Event Plots}
\usage{
plotEvents(formula, data, order = TRUE, return.grob = FALSE,
  control = list(), ...)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a "~" operator, and the terms on the right.
The response must be a recurrent event survival object as returned by function \code{reSurv}.}

\item{data}{an optional data frame in which to interpret the variables occurring in the "formula".}

\item{order}{an optional logical value. If "TRUE", the event plot is sorted by the terminal times; the default value is TRUE.}

\item{return.grob}{an optional logical value. If "TRUE", a \code{ggplot2} plot grob will be returned.}

\item{control}{a list of control parameters.}

\item{...}{for future developments.}
}
\description{
Plot the event plot for an \code{reSurv} object, with more flexible options.
}
\details{
The argument \code{control} consists of options with argument defaults to a list with the following values:
\describe{
  \item{xlab}{customizable x-label, default value is "Time".}
  \item{ylab}{customizable y-label, default value is "Subject".}
  \item{title}{customizable title, default value is "Recurrent event plot".}
  \item{terminal.name}{customizable label for terminal event, default value is "Terminal event".}
  \item{recurrent.name}{customizable label for recurrent event, default value is "Recurrent event plot".}
  \item{recurrent.types}{customizable label for recurrent event type, default value is NULL.}
  \item{alpha}{controls the transparency of points.}
}
}
\examples{
data(readmission)
plotEvents(reSurv(t.stop, event, death, id) ~ 1, data = readmission)

## Separate plots by gender
plotEvents(reSurv(t.stop, event, death, id) ~ sex, data = readmission)

## Separate plots by gender and chemo type
plotEvents(reSurv(t.stop, event, death, id) ~ sex + chemo, data = readmission)

## With multiple hypothetical event types
plotEvents(reSurv(t.stop, event * sample(1:3, 861, TRUE), death, id) ~
  sex + chemo, data = readmission)
}
\seealso{
\code{\link{reSurv}}, \code{\link{plot.reSurv}}
}
\keyword{plot.reSurv}
