% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readODS.R
\name{read_ods}
\alias{read.ods}
\alias{read_ods}
\title{read data from ods files}
\usage{
read_ods(path = NULL, sheet = 1, col_names = TRUE, col_types = NULL,
  na = "", skip = 0, formula_as_formula = FALSE, range = NULL)

read.ods(file = NULL, sheet = NULL, formulaAsFormula = FALSE)
}
\arguments{
\item{path}{path to the ods file.}

\item{sheet}{sheet to read. Either a string (the sheet name), or an integer sheet number. The default is 1.}

\item{col_names}{indicating whether the file contains the names of the variables as its first line.}

\item{col_types}{Either NULL to guess from the spreadsheet or refer to readr::type_convert to specify cols specification. NA will return a data frame with all columns being "characters".}

\item{na}{Missing value. By default read_ods converts blank cells to missing data.}

\item{skip}{the number of lines of the data file to skip before beginning to read data.}

\item{formula_as_formula}{a switch to display formulas as formulas "SUM(A1:A3)" or as the resulting value "3"... or "8"..}

\item{range}{selection of rectangle using Excel-like cell range, such as \code{range = "D12:F15"} or \code{range = "R1C12:R6C15"}. Cell range processing is handled by the \code{\link[=cellranger]{cellranger}} package.}

\item{file}{for read.ods only, path to the ods file.}

\item{formulaAsFormula}{for read.ods only, a switch to display formulas as formulas "SUM(A1:A3)" or as the resulting value "3"... or "8"..}
}
\value{
a data frame (\code{data.frame}) containing a representation of data in the ods file.
}
\description{
read_ods is a funtion to read a single sheet from a ods file and return a data frame.
read.ods always return a list of data frames with one data frame per sheet. This is a wrapper to read_ods for backward compatibility with previous version of readODS. Please use read_ods if possible.
}
\note{
Currently, ods files that linked to external data source cannot be read. Merged cells cannot be parsed correctly.
}
\author{
Chung-hong Chan <chainsawtiney@gmail.com>, Gerrit-Jan Schutten <phonixor@gmail.com>
}

