% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_sqlite_connection}
\alias{check_sqlite_connection}
\title{Check SQLite Connection}
\usage{
check_sqlite_connection(x, connected = NA, x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{connected}{A flag specifying whether x should be connected.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of the original object.
}
\description{
Checks whether an R object is a SQLite Connection.
}
\examples{
conn <- rws_connect()
check_sqlite_connection(conn)
rws_disconnect(conn)
check_sqlite_connection(conn, error = FALSE)
check_sqlite_connection(conn, connected = TRUE, error = FALSE)
}
