library(rearrr)
context("shear_3d()")


test_that("fuzz testing shear_3d()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "g" = rep(c(1, 2, 3, 4, 5), each = 3),
    stringsAsFactors = FALSE
  ) %>%
    dplyr::as_tibble()

  # Check that df hasn't changed

  ## Testing 'df'                                                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    df[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    df[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    df[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df),
    c("x", "y", "z", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df'                                                  ####


  # Fuzzing     ####

  # Generate expectations for 'rotate_3d'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = shear_3d,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1, 2, 3, 4, 5), "hej", NA),
  #     "x_col" = list("x", "y", NA),
  #     "y_col" = list("y", "x", NA),
  #     "z_col" = list("z", "x", "uhh", NA),
  #     "x_shear" = list(1, 0, -1,  c(4, -4), "hej", NA),
  #     "y_shear" = list(0, 1, -1, c(4, -4), "hej", NA),
  #     "z_shear" = list(NULL, 1, "hej", NA),
  #     "suffix" = list("", "_sheared", NA),
  #     "origin" = list(c(0, 0, 0), c(0.3, -0.3, 0.5), 0, "h", c(NA, 1, 0.4), c(NA, NA, NA),  NA),
  #     "origin_fn" = list(NULL, centroid),
  #     "keep_original" = list(FALSE),
  #     "shear_col_name" = list(".shear", ".sha", NA),
  #     "origin_col_name" = list(".origin", ".centroid", NA),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #       list("data" = c(1, 2, 3, 4, 5), "x_col" = NULL, "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #       list("data" = c(1, 2, 3, 4, 5), "x_col" = "x", "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #       list("data" = dplyr::group_by(df, g), "x_shear" = 10, "z_shear" = 10, "origin_fn" = centroid, "origin" = NULL),
  #       list("keep_original" = TRUE, "suffix" = "_sheared"),
  #       list("overwrite" = FALSE, "shear_col_name" = "g")
  #   ),
  #   indentation = 2
  # )


  ## Testing 'shear_3d'                                                       ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = dplyr::group_by(df, g), x_co...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- shear_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = c(1, 2, 3, 4, 5), x_col = "x...
  # Changed from baseline: data = c(1, 2, 3, 4, 5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(shear_3d(data = c(1, 2, 3, 4, 5), x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = "hej", x_col = "x", y_col = ...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(shear_3d(data = "hej", x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = NA, x_col = "x", y_col = "y"...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(shear_3d(data = NA, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = NULL, x_col = "x", y_col = "...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(shear_3d(data = NULL, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = c(1, 2, 3, 4, 5), x_col = NU...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(shear_3d(data = c(1, 2, 3, 4, 5), x_col = NULL, y_col = NULL, z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("3 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'.\n * Variable 'x_col': Must be of type 'string', not 'NULL'.\n * Variable 'y_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = c(1, 2, 3, 4, 5), x_col = "x...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(shear_3d(data = c(1, 2, 3, 4, 5), x_col = "x", y_col = NULL, z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("2 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'.\n * Variable 'y_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = dplyr::group_by(df, g), x_co...
  # Changed from baseline: data, x_shear, z_shea...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(shear_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_shear = 10, y_shear = 0, z_shear = 10, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Exactly 2 of {x_shear, y_shear, z_shear} must be non-null."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "y", y_col = "y"...
  # Changed from baseline: x_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "y", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = NA, y_col = "y",...
  # Changed from baseline: x_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = NA, y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = NULL, y_col = "y...
  # Changed from baseline: x_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = NULL, y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "x"...
  # Changed from baseline: y_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "x", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = NA,...
  # Changed from baseline: y_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = NA, z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = NUL...
  # Changed from baseline: y_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = NULL, z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_col = "uhh"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "uhh", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * These names in the 'col(s)' argument were not found in 'data': uhh."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = NA, x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "x", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = NULL, x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_shear = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_15603 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 0, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15603),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15603[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_15603[[".shear_str"]],
    c("x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0",
      "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0",
      "x=0,y=0", "x=0,y=0", "x=0,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_15603),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15603),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15603),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15603),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15603)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_shear = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_19040 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = -1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19040),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19040[["x"]],
    c(0.17721, 0.12602, -0.10197, 0.14528, 0.6378, -0.31382, 0.72925,
      -0.07299, -0.24961, 0.09329, 0.07818, 0.28334, 0.89724, -0.71811,
      0.03054),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19040[[".shear_str"]],
    c("x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0",
      "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0",
      "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19040),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19040),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19040),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19040),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19040)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_shear = c(4, -4)
  xpectr::set_test_seed(42)
  # Assigning output
  output_11387 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = c(4, -4), y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11387),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11387[["x"]],
    c(3.86519, 4.1813, 1.83857, 3.57113, 0.65754, 3.85076, 0.76592,
      0.9653, 4.2834, 3.15218, 1.97598, 2.4622, 1.0844, 4.14959, 2.1893,
      -2.03558, -2.30715, -1.26629, -1.91023, 0.62595, -2.81257, 0.70725,
      -0.69597, -2.96941, -1.74205, -1.0605, -1.02397, 0.78495, -3.63873,
      -1.26471),
    tolerance = 1e-4)
  expect_equal(
    output_11387[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836,
      0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871,
      0.98889, 0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697,
      0.836),
    tolerance = 1e-4)
  expect_equal(
    output_11387[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175, 0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292,
      0.00733, 0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743,
      0.97354, 0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_11387[[".shear_str"]],
    c("x=4,y=0", "x=4,y=0", "x=4,y=0", "x=4,y=0", "x=4,y=0", "x=4,y=0",
      "x=4,y=0", "x=4,y=0", "x=4,y=0", "x=4,y=0", "x=4,y=0", "x=4,y=0",
      "x=4,y=0", "x=4,y=0", "x=4,y=0", "x=-4,y=0", "x=-4,y=0", "x=-4,y=0",
      "x=-4,y=0", "x=-4,y=0", "x=-4,y=0", "x=-4,y=0", "x=-4,y=0",
      "x=-4,y=0", "x=-4,y=0", "x=-4,y=0", "x=-4,y=0", "x=-4,y=0",
      "x=-4,y=0", "x=-4,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_11387),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11387),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11387),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11387),
    c(30L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11387)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_shear = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = "hej", y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_shear': Must be of type 'numeric' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_shear = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = NA, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_shear': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: x_shear = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = NULL, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Exactly 2 of {x_shear, y_shear, z_shear} must be non-null."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_shear = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_15142 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 1, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15142),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15142[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_15142[["y"]],
    c(1.67761, 1.78928, 0.5056, 1.16017, 0.56428, 1.73695, 0.14604,
      1.19655, 1.85327, 0.69422, 0.89377, 0.82598, 0.94317, 1.42051,
      1.26776),
    tolerance = 1e-4)
  expect_equal(
    output_15142[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_15142[[".shear_str"]],
    c("x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1",
      "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1",
      "x=1,y=1", "x=1,y=1", "x=1,y=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_15142),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15142),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15142),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15142),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15142)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_shear = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_13902 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = -1, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13902),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13902[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_13902[["y"]],
    c(0.20242, 0.16717, -0.27062, -0.21017, 0.55638, 0.07112, 0.13138,
      0.78123, 0.04007, -0.52934, 0.13465, -0.04557, 0.86831, -0.52657,
      0.40425),
    tolerance = 1e-4)
  expect_equal(
    output_13902[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".shear_str"]],
    c("x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1",
      "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1",
      "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_13902),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13902),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13902),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13902),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13902)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_shear = c(4, -4)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19057 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = c(4, -4), z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19057),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19057[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404, 1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201,
      0.74392, 0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721,
      1.22897, 0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["y"]],
    c(3.8904, 4.22245, 1.66992, 3.21568, 0.57613, 4.2357, 0.16805, 1.81953,
      4.57307, 2.52955, 2.03245, 2.13329, 1.05546, 4.34113, 2.56301,
      -2.01037, -2.26599, -1.43495, -2.26568, 0.54454, -2.42763, 0.10937,
      0.15826, -2.67974, -2.36468, -1.00403, -1.35288, 0.75601, -3.44719,
      -0.891),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175, 0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292,
      0.00733, 0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743,
      0.97354, 0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19057[[".shear_str"]],
    c("x=1,y=4", "x=1,y=4", "x=1,y=4", "x=1,y=4", "x=1,y=4", "x=1,y=4",
      "x=1,y=4", "x=1,y=4", "x=1,y=4", "x=1,y=4", "x=1,y=4", "x=1,y=4",
      "x=1,y=4", "x=1,y=4", "x=1,y=4", "x=1,y=-4", "x=1,y=-4", "x=1,y=-4",
      "x=1,y=-4", "x=1,y=-4", "x=1,y=-4", "x=1,y=-4", "x=1,y=-4",
      "x=1,y=-4", "x=1,y=-4", "x=1,y=-4", "x=1,y=-4", "x=1,y=-4",
      "x=1,y=-4", "x=1,y=-4"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19057),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19057),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19057),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19057),
    c(30L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19057)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_shear = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = "hej", z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_shear': Must be of type 'numeric' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_shear = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = NA, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_shear': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: y_shear = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = NULL, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Exactly 2 of {x_shear, y_shear, z_shear} must be non-null."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_shear = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = 1, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Exactly 2 of {x_shear, y_shear, z_shear} must be non-null."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_shear = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = "hej", suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_shear': Must be of type 'numeric' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: z_shear = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NA, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_shear': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix = "_sheared"
  xpectr::set_test_seed(42)
  # Assigning output
  output_10039 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "_sheared", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10039),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10039[["x_sheared"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_10039[["y_sheared"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_10039[["z_sheared"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_10039[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10039),
    c("x_sheared", "y_sheared", "z_sheared", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10039),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10039),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10039),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10039)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18329 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = NA, origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10073 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = NULL, origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: suffix, keep_original
  xpectr::set_test_seed(42)
  # Assigning output
  output_12076 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "_sheared", origin = c(0, 0, 0), origin_fn = NULL, keep_original = TRUE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_12076),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12076[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_12076[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_12076[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_12076[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_12076[["x_sheared"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_12076[["y_sheared"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_12076[["z_sheared"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_12076[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_12076),
    c("x", "y", "z", "g", "x_sheared", "y_sheared", "z_sheared", ".origin",
      ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12076),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12076),
    c("double", "double", "double", "double", "double", "double", "double",
      "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12076),
    c(15L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12076)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = c(0.3, -0.3,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19066 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0.3, -0.3, 0.5), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19066),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19066[["x"]],
    c(1.1524, 1.24813, 0.17425, 1.01562, 0.14569, 0.85201, 0.24392,
      -0.15767, 1.06359, 0.81684, 0.3373, 0.65488, 0.4721, 0.72897,
      0.39404),
    tolerance = 1e-4)
  expect_equal(
    output_19066[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19066[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19066[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19066),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19066),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19066),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19066),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19066)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16117 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = 0, origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 3, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = "h"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13795 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = "h", origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must be of type 'numeric' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = c(NA, 1, 0.4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14357 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(NA, 1, 0.4), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = c(NA, NA, NA)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10374 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(NA, NA, NA), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10374[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10374[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19735 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = NA, origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 3, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14317 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = NULL, origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin_fn = centroid
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19575 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19575[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19575[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_19575 <- xpectr::suppress_mw(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_19575),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19575[["x"]],
    c(1.15572, 1.25145, 0.17757, 1.01894, 0.14901, 0.85533, 0.24724,
      -0.15436, 1.06691, 0.82016, 0.34062, 0.6582, 0.47542, 0.73229,
      0.39736),
    tolerance = 1e-4)
  expect_equal(
    output_19575[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19575[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19575[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19575),
    c("x", "y", "z", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19575),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19575),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19575),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19575)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18877 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = NULL, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18877[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18877[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: shear_col_name = ".sha"
  xpectr::set_test_seed(42)
  # Assigning output
  output_16399 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".sha", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16399),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16399[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_16399[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_16399[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_16399[[".sha_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16399),
    c("x", "y", "z", ".origin", ".sha", ".sha_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16399),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16399),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16399),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16399)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: shear_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19709 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = NA, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19709[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'shear_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19709[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: shear_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_16188 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = NULL, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16188),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16188[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_16188[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_16188[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16188),
    c("x", "y", "z", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16188),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16188),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16188),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16188)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: shear_col_name, overw...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13334 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = "g", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13334[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13334[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin_col_name = ".c...
  xpectr::set_test_seed(42)
  # Assigning output
  output_13467 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".centroid", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13467),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13467[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_13467[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_13467[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_13467[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_13467),
    c("x", "y", "z", ".centroid", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13467),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13467),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13467),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13467)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13984 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13984[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13984[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_17846 <- shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17846),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17846[["x"]],
    c(1.6524, 1.74813, 0.67425, 1.51562, 0.64569, 1.35201, 0.74392,
      0.34233, 1.56359, 1.31684, 0.8373, 1.15488, 0.9721, 1.22897,
      0.89404),
    tolerance = 1e-4)
  expect_equal(
    output_17846[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17846[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_17846[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17846),
    c("x", "y", "z", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17846),
    c("numeric", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17846),
    c("double", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17846),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17846)),
    character(0),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10389 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10389[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: x, y, z."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10389[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_3d(data = df, x_col = "x", y_col = "y"...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17487 <- xpectr::capture_side_effects(shear_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_shear = 1, y_shear = 0, z_shear = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17487[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17487[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'shear_3d'                                              ####
  #

})

test_that("testing expected output with shear_3d()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = c(1, 2, 3),
    "y" = c(11, 12, 13),
    "z" = c(101, 102, 103)
  )
  mat <- t(df)

  # Given x and y shears ####

  # Expected (manual calculation)
  x_shear <- 3
  y_shear <- 7
  shearing_mat <- matrix(c(1, 0, 0,
                           0, 1, 0,
                           x_shear, y_shear, 1),
                         nrow = 3)
  manually_sheared <- shearing_mat %*% mat

  # Rearrr version
  rearrr_sheared <- shear_3d(
    df,
    x_col = "x",
    y_col = "y",
    z_col = "z",
    x_shear = x_shear,
    y_shear = y_shear,
    origin = c(0, 0, 0)
  )

  # Check manual and rearrr shears are the same
  expect_equal(
    as.numeric(t(rearrr_sheared[, c("x_sheared", "y_sheared", "z_sheared")])),
    as.numeric(manually_sheared)
  )


  ## Testing 'rearrr_sheared'                                               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(rearrr_sheared),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    rearrr_sheared[["x"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["z"]],
    c(101, 102, 103),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["x_sheared"]],
    c(304, 308, 312),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y_sheared"]],
    c(718, 726, 734),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["z_sheared"]],
    c(101, 102, 103),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[[".shear_str"]],
    c("x=3,y=7", "x=3,y=7", "x=3,y=7"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(rearrr_sheared),
    c("x", "y", "z", "x_sheared", "y_sheared", "z_sheared", ".origin",
      ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(rearrr_sheared),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(rearrr_sheared),
    c("double", "double", "double", "double", "double", "double", "list",
      "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(rearrr_sheared),
    c(3L, 9L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(rearrr_sheared)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'rearrr_sheared'                                      ####


  # Given x and z shears ####

  # Expected (manual calculation)
  x_shear <- 3
  z_shear <- 7
  shearing_mat <- matrix(c(1, 0, 0,
                           x_shear, 1, z_shear,
                           0, 0, 1),
                         nrow = 3)
  manually_sheared <- shearing_mat %*% mat

  # Rearrr version
  rearrr_sheared <- shear_3d(
    df,
    x_col = "x",
    y_col = "y",
    z_col = "z",
    x_shear = x_shear,
    z_shear = z_shear,
    origin = c(0, 0, 0)
  )

  # Check manual and rearrr shears are the same
  expect_equal(
    as.numeric(t(rearrr_sheared[, c("x_sheared", "y_sheared", "z_sheared")])),
    as.numeric(manually_sheared)
  )

  ## Testing 'rearrr_sheared'                                               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(rearrr_sheared),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    rearrr_sheared[["x"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["z"]],
    c(101, 102, 103),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["x_sheared"]],
    c(34, 38, 42),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y_sheared"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["z_sheared"]],
    c(178, 186, 194),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[[".shear_str"]],
    c("x=3,z=7", "x=3,z=7", "x=3,z=7"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(rearrr_sheared),
    c("x", "y", "z", "x_sheared", "y_sheared", "z_sheared", ".origin",
      ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(rearrr_sheared),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(rearrr_sheared),
    c("double", "double", "double", "double", "double", "double", "list",
      "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(rearrr_sheared),
    c(3L, 9L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(rearrr_sheared)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'rearrr_sheared'                                      ####


  # Given z and y shears ####

  # Expected (manual calculation)
  z_shear <- 3
  y_shear <- 7
  shearing_mat <- matrix(c(1, y_shear, z_shear,
                           0, 1, 0,
                           0, 0, 1),
                         nrow = 3)
  manually_sheared <- shearing_mat %*% mat

  # Rearrr version
  rearrr_sheared <- shear_3d(
    df,
    x_col = "x",
    y_col = "y",
    z_col = "z",
    z_shear = z_shear,
    y_shear = y_shear,
    origin = c(0, 0, 0)
  )

  # Check manual and rearrr shears are the same
  expect_equal(
    as.numeric(t(rearrr_sheared[, c("x_sheared", "y_sheared", "z_sheared")])),
    as.numeric(manually_sheared)
  )


  ## Testing 'rearrr_sheared'                                               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(rearrr_sheared),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    rearrr_sheared[["x"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["z"]],
    c(101, 102, 103),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["x_sheared"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y_sheared"]],
    c(18, 26, 34),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["z_sheared"]],
    c(104, 108, 112),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[[".shear_str"]],
    c("y=7,z=3", "y=7,z=3", "y=7,z=3"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(rearrr_sheared),
    c("x", "y", "z", "x_sheared", "y_sheared", "z_sheared", ".origin",
      ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(rearrr_sheared),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(rearrr_sheared),
    c("double", "double", "double", "double", "double", "double", "list",
      "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(rearrr_sheared),
    c(3L, 9L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(rearrr_sheared)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'rearrr_sheared'                                      ####


})
