% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_n_fn.R
\name{median_index}
\alias{median_index}
\alias{quantile_index}
\title{Find index of interest for each vector}
\usage{
median_index(..., negate = FALSE, round_fn = round)

quantile_index(..., prob, type = 7, negate = FALSE, round_fn = round)
}
\arguments{
\item{...}{Numeric \code{vector}s.}

\item{negate}{Whether to negate the result. I.e. to multiply it with \code{-1}. (Logical)}

\item{round_fn}{Function for rounding output. Rounding is done \emph{prior} to negation.

E.g. \code{\link[base:Round]{round}}, \code{\link[base:Round]{floor}}, or \code{\link[base:Round]{ceiling}}.}

\item{prob}{Probability in \code{[0,1]} for \code{\link[stats:quantile]{quantile()}}.}

\item{type}{Quantile algorithm to use. See \code{\link[stats:quantile]{quantile()}}.}
}
\value{
\code{numeric vector} with one element per supplied vector.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Applies function to the indices of each \code{vector} in \code{`...`}.

These functions were created with \code{\link[rearrr:create_n_fn]{create_n_fn()}}.
}
\examples{
\donttest{
# Attach packages
library(rearrr)

# Set seed
set.seed(1)

# Create three vectors
x <- runif(10)
y <- runif(15)
z <- runif(20)

median_index(x, y, z)
quantile_index(x, y, z, prob = 0.2)

# Negate result
median_index(x, y, z, negate = TRUE)
}
}
\seealso{
Other n functions: 
\code{\link{create_n_fn}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{n functions}
