% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_PIT_local.R
\name{gg_PIT_local}
\alias{gg_PIT_local}
\title{Plots Density Distributions of PIT-values for global calibration diagnose.}
\usage{
gg_PIT_local(
  pit_local,
  alpha = 0.4,
  linewidth = 1,
  pal = "Set2",
  facet = FALSE
)
}
\arguments{
\item{pit_local}{A tibble with five column names "part", "y_cal",
"y_hat", "pit" and "n".}

\item{alpha}{double 0-1 to indicate transparency of fill. Default is 0.4.}

\item{linewidth}{integer linewidth of density line. Default set to 1.}

\item{pal}{a chosen RBrewer color pallete. Default is "Set2"}

\item{facet}{Logical iforming if the plot should use face_wrap() to separate the different localities.}
}
\value{
A ggplot
}
\description{
A function based on ggplot2 to observe the local the density of PIT-values.
To use this function we recommend providing the PIT-values returned by the PIT_local function from this package or an object of equivalent format.
Layers can be edited like in http://cran.nexr.com/web/packages/ggpmisc/vignettes/user-guide-4.html.
}
\examples{
 n <- 10000
 mu <- function(x1){
  10 + 5*x1^2
  }

sigma_v <- function(x1){
 30*x1
}

x <- runif(n, 2, 20)
y <- rnorm(n, mu(x), sigma_v(x))

x_train <- x[1:(n*0.8)]
y_train <- y[1:(n*0.8)]

x_cal <- x[(n*0.8+1):n]
y_cal <- y[(n*0.8+1):n]

model <- lm(y_train ~ x_train)

y_hat <- predict(model, newdata=data.frame(x_train=x_cal))

MSE_cal <- mean((y_hat - y_cal)^2)

pit_local <- PIT_local(xcal = x_cal, ycal=y_cal, yhat=y_hat, mse=MSE_cal)

gg_PIT_local(pit_local)
gg_PIT_local(pit_local, facet=TRUE)
}
