% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{link}
\alias{link}
\title{Use the selected pairs to generate a linked data set}
\usage{
link(pairs, selection = NULL, x = NULL, y = NULL, all_x = TRUE,
  all_y = TRUE, ...)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{selection}{a logical variable with the same length as \code{pairs} has
rows, or the name of such a variable in \code{pairs}. Pairs are only 
selected when \code{select} is \code{TRUE}. When missing 
\code{attr(pairs, "selection")} is used when available.}

\item{x}{the first data set; when missing \code{attr(pairs, "x")} is used.}

\item{y}{the second data set; when missing \code{attr(pairs, "y")} is used.}

\item{all_x}{return all records from \code{x}.}

\item{all_y}{return all records from \code{y}.}

\item{...}{ignored.}
}
\description{
Use the selected pairs to generate a linked data set
}
\details{
Uses the selected pairs to link the two data sets to each other. Renames 
variables that are in both data sets.
}
