% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clean_rows.R
\name{get_clean_rows}
\alias{get_clean_rows}
\title{Get Clean Rows}
\usage{
get_clean_rows(playback, ignore_tests = NULL, ignore_cols = NULL,
  ignore_combinations = NULL)
}
\arguments{
\item{playback}{\code{data.playback} to extract failed tests from.}

\item{ignore_tests}{\code{character} ignore test results from tests with 
these names.}

\item{ignore_cols}{\code{character} ignore test results from tests of 
columns with these names.}

\item{ignore_combinations}{\code{list} ignore test results from specific 
tests of specific columns.}
}
\value{
\code{logical} with the same length as the number of rows in new 
data. The value is TRUE, if the row passed all tests, otherwise FALSE.
}
\description{
Get Clean Rows
}
\details{
Look up the descriptions and other meta data of the available 
validation tests with \code{\link{get_tests_meta_data}}.
}
\examples{
# record tape from `iris`.
tape <- record(iris)
# load data.
data(iris_newdata)
# validate new data by playing new tape on it.
playback <- play(tape, iris_newdata)

get_clean_rows(playback)
get_clean_rows(playback, ignore_tests = "outside_range")
get_clean_rows(playback, ignore_cols = "junk")
get_clean_rows(playback, ignore_combinations = list(outside_range = "Sepal.Width"))
}
