% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{map.sdm}
\alias{map.sdm}
\title{Predict species distribution.}
\usage{
map.sdm(longlat, layers, bg = NULL, categorical = NULL, thres = 1,
  polygon = TRUE, eval = TRUE, runs = 0, subset = 0)
}
\arguments{
\item{longlat}{Matrix of longitude and latitude (two columns) of each occurrence record.}

\item{layers}{Predictor variables, a Raster* object as defined by package raster.}

\item{bg}{Background data as a matrix of longitude and latitude (two columns). If not defined 1000 points will be randomly selected.}

\item{categorical}{Vector of layer indices of categorical (as opposed to quantitative) data. If NULL the package will try to find them automatically based on the data itself.}

\item{thres}{Threshold of logistic output used for conversion of probabilistic to binary (presence/absence) maps. If 1 this will be the value that maximizes the sum of sensitivity and specificity.}

\item{polygon}{Used for a precautionary approach. If TRUE, all areas predicted as present but outside the minimum convex hull polygon encompassing all occurrence records are converted to absence. Only cells connected to other areas inside the polygon are kept.}

\item{eval}{Build a matrix with AUC, Kappa, TSS, EOO (from raw data), EOO (from model), AOO (from raw data) and AOO (from model).}

\item{runs}{If <= 0 no ensemble modelling is performed. If > 0, ensemble modelling with n runs is made. For each run a bootstrap (random sampling with replacement) of all occurrence records and a new set of 1000 background points (if bg = NULL) are chosen.}

\item{subset}{Number of predictive variables to be randomly selected from layers for each run if runs > 0. If <= 0 all layers are used on all runs.}
}
\value{
Either one or two raster files (depending if ensemble modelling is performed, in which case the second is a probabilistic map from all the runs) and possibly a matrix with AUC, Kappa, TSS, EOO (from raw data), EOO (from model), AOO (from raw data) and AOO (from model). Aggregate values are taken from maps after transformation of probabilities to incidence, with presence predicted for cells with presence for 50% or more of the runs.
}
\description{
Prediction of potential species distributions using maximum entropy (maxent).
}
\details{
Builds maxent (maximum entropy) species distribution models (Phillips et al. 2004, 2006; Elith et al. 2011) using function maxent from R package dismo (Hijmans et al. 2016). Dismo requires the MaxEnt species distribution model software, a java program that can be downloaded from https://www.cs.princeton.edu/~schapire/maxent/. Put the file 'maxent.jar' in the 'java' folder of the dismo package. That is the folder returned by system.file("java", package="dismo"). You need MaxEnt version 3.3.3b or higher. Please note that this program (maxent.jar) cannot be redistributed or used for commercial or for-profit purposes.
}
\references{
Hijmans, R.J., Phillips, S., Leathwick, J., Elith, J. (2016) dismo: Species Distribution Modeling. R package version 1.0-15. https://CRAN.R-project.org/package=dismo

Phillips, S.J., Dudik, M., Schapire, R.E. (2004) A maximum entropy approach to species distribution modeling. Proceedings of the Twenty-First International Conference on Machine Learning. p. 655-662.

Phillips, S.J., Anderson, R.P., Schapire, R.E. (2006) Maximum entropy modeling of species geographic distributions. Ecological Modelling 190:231-259.

Elith, J., Phillips, S.J., Hastie, T., Dudik, M., Chee, Y.E., Yates, C.J. (2011) A statistical explanation of MaxEnt for ecologists. Diversity and Distributions 17:43-57.
}

