% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{raster.reduce}
\alias{raster.reduce}
\title{Reduce dimensionality of raster layers.}
\usage{
raster.reduce(layers, method = "pca", n = NULL, thres = NULL)
}
\arguments{
\item{layers}{Raster* object as defined by package raster.}

\item{method}{Either Principal Components Analysis (pca, default) or Pearson's correlation (cor).}

\item{n}{Number of layers to reduce to.}

\item{thres}{Value for pairwise Pearson's correlation above which one of the layers (randomly selected) is eliminated.}
}
\value{
A RasterStack object.
}
\description{
Reduce the number of layers by either performing a PCA on them or by eliminating highly correlated ones.
}
\details{
Using a large number of explanatory variables in models with few records may lead to overfitting. This function allows to avoid it as much as possible.
If both n and thres are given, n has priority. If method is not recognized and layers come from raster.read function, only landcover is reduced by using only the dominating landuse of each cell.
}

