% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rli.R
\name{rli.predict}
\alias{rli.predict}
\title{Prediction of Red List Index.}
\usage{
rli.predict(rliValue, from = NA, to = NA, rliPlot = FALSE)
}
\arguments{
\item{rliValue}{Should be a vector with RLI values and names as the corresponding year numbers.}

\item{from}{Starting year of the sequence to predict.}

\item{to}{Ending year of the sequence to predict.}

\item{rliPlot}{Plots the result}
}
\value{
A matrix with the RLI values and confidence limits.
}
\description{
Linearly interpolates and extrapolates RLI values to any years.
}
\details{
The IUCN Red List Index (RLI) (Butchart et al. 2004, 2007) reflects overall changes in IUCN Red List status over time of a group of taxa.
}
\examples{
rliValue <- c(4.5, 4.3, 4.4, 4.2, 4.0)
names(rliValue) <- c(2000, 2004, 2008, 2011, 2017)
rli.predict(rliValue, 1990, 2020)
}
