% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportArms.R
\name{exportArms}
\alias{exportArms}
\alias{exportArms.redcapApiConnection}
\title{Export the Arms for a Project}
\usage{
exportArms(rcon, ...)

\method{exportArms}{redcapApiConnection}(
  rcon,
  arms = character(0),
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}.}

\item{...}{Arguments to be passed to other methods.}

\item{arms}{\code{character} identifying the arm numbers to retrieve. In REDCap 6.5.0, 
using this argument results in an empty data frame being returned.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
Returns a data frame with two columns

\itemize{
  \item{\code{arm_num} }{The arm number}
  \item{\code{name} }{The arm's descriptive name}
}
}
\description{
This function allows you to export the Arms for a project
  Note: this only works for longitudinal projects
}
\details{
It is not sufficient to make the project a longitudinal project. The
project must satisfy one of two conditions: 1) have at least two arms and
one event defined in each arm; or 2) have one arm and at least two events defined. If 
neither of these conditions are satisfied, the API will return a message
such as \code{ERROR: You cannot export arms for classic projects}, an 
error message that isn't as descriptive of the nature of the problem as 
we might like.

If the project information reports that the project is not longitudinal, 
a data frame with 0 rows is returned without calling the API.
}
\section{REDCap API Documentation}{

This function allows you to export the Arms for a project

NOTE: this only works for longitudinal projects.
}

\section{REDCap Version}{

5.8.2+
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/vubiostat/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
