plans <- plans_10[, 1:2]

test_that('compactness works', {
  comp <- redist.compactness(
    shp = fl25, plans = plans,
    measure = 'all', total_pop = pop, planarize = FALSE,
    counties = rep(1, 25)
  )
  expected <- structure(list(district = c(1L, 2L, 3L, 1L, 2L, 3L), PolsbyPopper = c(
    0.285408144266143,
    0.246155768275462, 0.335907604022625, 0.397299799481666, 0.246155768275462,
    0.234180177544589
  ), Schwartzberg = c(
    1.87183179142943, 2.01555656773328,
    1.72540114699652, 1.58650274209474, 2.01555656773328, 2.06645015710485
  ), LengthWidth = c(
    0.926285160038819, 0.653935724266415, 0.404149212048674,
    0.874431619447365, 0.653935724266415, 0.417276720351394
  ), ConvexHull = c(
    0.68886719971328,
    0.657283200146699, 0.696409105212057, 0.724494964993755, 0.657283200146699,
    0.598769626173265
  ), Reock = c(
    0.43437300523785, 0.306645852527558,
    0.224742497097297, 0.424640741237631, 0.306645852527558, 0.210845488809258
  ), BoyceClark = c(
    0.855392779807052, 0.750250900412383, 0.735085159873138,
    0.832201015045522, 0.750250900412383, 0.804636547547239
  ), FryerHolden = c(
    1465234537524622336,
    1465234537524622336, 1465234537524622336, 1189001370168647680,
    1189001370168647680, 1189001370168647680
  ), EdgesRemoved = c(
    32,
    32, 32, 32, 32, 32
  ), FracKept = c(
    0.372549019607843, 0.372549019607843,
    0.372549019607843, 0.372549019607843, 0.372549019607843, 0.372549019607843
  ), logSpanningTree = c(
    12.6907185515128, 12.6907185515128, 12.6907185515128,
    12.6907185515128, 12.6907185515128, 12.6907185515128
  ), draw = c(
    1,
    1, 1, 2, 2, 2
  )), row.names = c(NA, -6L), class = c(
    'tbl_df',
    'tbl', 'data.frame'
  ))

  expect_equal(comp, expected)
})


test_that('test prep polsbypopper works', {
  test <- redist.prep.polsbypopper(shp = fl25)

  expect_s3_class(test, class = 'data.frame')
})
