% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_deprecations.R, R/deprecations.R
\name{competitiveness}
\alias{competitiveness}
\alias{redist.competitiveness}
\title{Compute Competitiveness}
\usage{
competitiveness(map, rvote, dvote, .data = cur_plans())

redist.competitiveness(plans, rvote, dvote, alpha = 1, beta = 1)
}
\arguments{
\item{map}{a \code{\link{redist_map}} object}

\item{rvote}{A numeric vector with the Republican vote for each precinct.}

\item{dvote}{A numeric vector with the Democratic vote for each precinct.}

\item{.data}{a \code{\link{redist_plans}} object}

\item{plans}{A numeric vector (if only one map) or matrix with one row
for each precinct and one column for each map. Required.}

\item{alpha}{A numeric value for the alpha parameter for the talisman metric}

\item{beta}{A numeric value for the beta parameter for the talisman metric}
}
\value{
Numeric vector with competitiveness scores
}
\description{
Currently only implements the competitiveness function in equation (5)
of Cho & Liu 2016.
}
\examples{
data(fl25)
data(fl25_enum)

plans_05 <- fl25_enum$plans[, fl25_enum$pop_dev <= 0.05]
# old: comp <- redist.competitiveness(plans_05, fl25$mccain, fl25$obama)
comp <- compet_talisman(plans_05, fl25, mccain, obama)

}
\concept{analyze}
