% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_sscd}
\alias{part_sscd}
\title{Calculate Smoothed Seat Count Deviation}
\usage{
part_sscd(plans, shp, dvote, rvote)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{dvote}{unqouted name of column in shp with total population}

\item{rvote}{unqouted name of column in shp with group population}
}
\value{
numeric vector
}
\description{
Calculate Smoothed Seat Count Deviation
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_sscd(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_sscd(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Gregory Herschlag, Han Sung Kang, Justin Luo, Christy Vaughn Graves, Sachet Bangia,
Robert Ravier & Jonathan C. Mattingly (2020) Quantifying Gerrymandering in North Carolina,
Statistics and Public Policy, 7:1, 30-38, DOI: 10.1080/2330443X.2020.1796400
}
\concept{partisan}
