% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_basis.R
\name{smooth.construct.dt.smooth.spec}
\alias{smooth.construct.dt.smooth.spec}
\title{Domain Transformation basis constructor}
\usage{
\method{smooth.construct}{dt.smooth.spec}(object, data, knots)
}
\arguments{
\item{object}{a smooth specification object, generated by \code{s()},
\code{te()}, \code{ti()}, or \code{t2()}, with \code{bs="dt"}}

\item{data}{a list containing just the data (including any by variable)
required by this term, with names corresponding to \code{object$term}
(and \code{object$by}). The \code{by} variable is the last element.}

\item{knots}{a list containing any knots supplied for basis setup - in same
order and with same names as \code{data}. Can be \code{NULL}.}
}
\value{
An object of class "dt.smooth". This will contain all the elements
  associated with the \code{\link[mgcv]{smooth.construct}} object from the
  inner smooth (defined by \code{xt$bs}), in addition to an \code{xt}
  element used by the \code{Predict.matrix} method.
}
\description{
The \code{dt} basis allows for any of the standard \code{mgcv} (or
  user-defined) bases to be aplied to a transformed version of the
  original terms. Smooths may be of any number of terms. Transformations
  are specified by supplying a function of any or all of the original terms.
  "\code{by}" variables are not transformed.
}
\details{
\code{object} should be creaated with an \code{xt} argument. For
non-tensor-product smooths, this will be a list with the following elements:
\enumerate{
  \item \code{tf} (required): a function or character string (or list of functions
  and/or character strings) defining the coordinate transformations; see
  further details below.
  \item \code{bs} (optional): character string indicating the \code{bs} for
  the basis applied to the transformed coordinates; if empty, the appropriate
  defaults are used.
  \item \code{basistype} (optional): character string indicating type of
  bivariate basis used. Options include \code{"s"} (the default), \code{"te"},
  \code{"ti"}, and \code{"t2"}, which correspond to \code{\link[mgcv]{s}},
  \code{\link[mgcv]{te}}, \code{\link[mgcv]{ti}}, and \code{\link[mgcv]{t2}}.
  \item \code{...} (optional): for tensor product smooths, additional arguments
  to the function specified by \code{basistype} that are not available in
  \code{s()} can be included here, e.g. \code{d}, \code{np}, etc.
}

For tensor product smooths, we recommend using \code{s()} to set up the basis,
and specifying the tensor product using \code{xt$basistype} as described
above. If the basis is set up using \code{te()}, then the variables in
\code{object$term} will be split up, meaning all transformation functions
would have to be univariate.
}
\section{Transformation Functions}{


Let \code{nterms = length(object$term)}. The \code{tf} element can take one
of the following forms:
\enumerate{
  \item a function of \code{nargs} arguments, where \code{nargs <= nterms}.
    If \code{nterms > 1}, it is assumed that this function will be applied to
    the first term of \code{object$term}. If all argument names of the
    function are term names, then those arguments will correspond to those
    terms; otherwise, they will correspond to the first \code{nargs} terms in
    \code{object$term}.
  \item a character string corresponding to one of the built-in
    transformations (listed below).
  \item A list of length \code{ntfuncs}, where \code{ntfuncs<=nterms},
    containing either the functions or character strings described above. If
    this list is named with term names, then the transformation functions
    will be applied to those terms; otherwise, they will be applied to the
    first \code{ntfuncs} terms in \code{object$term}.
}
The following character strings are recognized as built-in transformations:
\itemize{
  \item \code{"log"}: log transformation (univariate)
  \item \code{"ecdf"}: empirical cumulative distribution function (univariate)
  \item \code{"linear01"}: linearly rescale from 0 to 1 (univariate)
  \item \code{"s-t"}: first term ("s") minus the second term ("t") (bivariate)
  \item \code{"s/t"}: first term ("s") divided by the second term ("t") (bivariate)
  \item \code{"QTransform"}: performs a time-specific ecdf transformation for
    a bivariate smooth, where time is indicated by the first term, and
    \eqn{x} by the second term. Primarily for use with \code{refund::af}.
}



Some transformations rely on a fixed "pivot point" based on the data used to
fit the model, e.g. quantiles (such as the min or max) of this data.
When making predictions based on these transformations, the transformation
function will need to know what the pivot points are, based on the original
(not prediction) data. In order to accomplish this, we allow the user to
specify that they want their transformation function to refer to the original
data (as opposed to whatever the "current" data is). This is done by appending
a zero ("0") to the argument name.

For example, suppose you want to scale
the term linearly so that the data used to define the basis ranges from
0 to 1. The wrong way to define this transformation function:
\code{function(x) {(x - min(x))/(max(x) - min(x))}}.
This function will result in incorrect predictions if the range of data for
which preditions are being made is not the same as the range of data that was
used to define the basis. The proper way to define this function:
\code{function(x) {(x - min(x0))/(max(x0) - min(x0))}}.
By refering to \code{x0} instead of \code{x}, you are indicating that you
want to use the original data instead of the current data. This may seem
strange to refer to a variable that is not one of the arguments, but the
\code{"dt"} constructor explicitly places these variables in the environment
of the transformation function to make them available.
}

\seealso{
\code{\link[mgcv]{smooth.construct}}
}
\author{
Jonathan Gellar
}
