% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwcv.R
\name{pwcv}
\alias{pwcv}
\title{Pointwise cross-validation for function-on-scalar regression}
\usage{
pwcv(
  fdobj,
  Z,
  L = NULL,
  lambda,
  eval.pts = seq(min(fdobj$basis$range), max(fdobj$basis$range), length.out = 201),
  scale = FALSE
)
}
\arguments{
\item{fdobj}{a functional data object (class \code{fd}) giving the
functional responses.}

\item{Z}{the model matrix, whose columns represent scalar predictors.}

\item{L}{a row vector or matrix of linear contrasts of the coefficient
functions, to be restricted to equal zero.}

\item{lambda}{smoothing parameter: either a nonnegative scalar or a vector,
of length \code{ncol(Z)}, of nonnegative values.}

\item{eval.pts}{argument values at which the CV score is to be evaluated.}

\item{scale}{logical value or vector determining scaling of the matrix
\code{Z} (see \code{\link{scale}}, to which the value of this argument is
passed).}
}
\value{
A vector of the same length as \code{eval.pts} giving the CV
scores.
}
\description{
Estimates prediction error for a function-on-scalar regression model by
leave-one-function-out cross-validation (CV), at each of a specified set of
points.
}
\details{
Integrating the pointwise CV estimate over the function domain yields the
\emph{cross-validated integrated squared error}, the standard overall model
fit score returned by \code{\link{lofocv}}.

It may be desirable to derive the value of \code{lambda} from an
appropriate call to \code{\link{fosr}}, as in the example below.
}
\references{
Reiss, P. T., Huang, L., and Mennes, M. (2010).  Fast
function-on-scalar regression with penalized basis expansions.
\emph{International Journal of Biostatistics}, 6(1), article 28.  Available
at \url{https://pubmed.ncbi.nlm.nih.gov/21969982/}
}
\seealso{
\code{\link{fosr}}, \code{\link{lofocv}}
}
\author{
Philip Reiss \email{phil.reiss@nyumc.org}
}
