% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfpca_helpers.R
\name{coarsen_index}
\alias{coarsen_index}
\title{Coarsen an index vector to a given resolution}
\usage{
coarsen_index(index, significant_digits)
}
\arguments{
\item{index}{Numeric vector of index values.}

\item{significant_digits}{Positive integer value.}
}
\value{
Numeric vector of rounded index values.
}
\description{
Reduce the resolution of a numeric vector by specifying the number of
\code{significant_digits} to which the numbers should be rounded. \cr \cr
Internal function used to coarsen the index vector before estimating the
two-step GFPCA with \code{\link{gfpca_twoStep}}.
}
\examples{
index_vector = c(0.7892, 0.2984, 0.328)
registr:::coarsen_index(index_vector, 1)
registr:::coarsen_index(index_vector, 3)

index_vector2 = c(2803, -7639, 13)
registr:::coarsen_index(index_vector2, 1)
registr:::coarsen_index(index_vector2, 3)

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de}
}
