% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_effect}
\alias{plot_effect}
\title{plotting the marginal effect of X on Y, with or without one or multiple interaction terms}
\usage{
plot_effect(
  reg.coef,
  data,
  model,
  by_color = FALSE,
  x_var.name = NULL,
  y_var.name = NULL,
  moderator.name = NULL,
  min_x = 0.001,
  max_x = 0.999,
  mdrt_quantile_05 = NULL,
  mdrt_quantile_50 = NULL,
  mdrt_quantile_95 = NULL,
  mod.n.sd = 1,
  confidence_interval = FALSE,
  v = NULL,
  CI_Ribbon = FALSE,
  title = NULL,
  xlab = "X_Var.name",
  ylab = "Y_Var.name",
  moderator.lab = "Moderator_name",
  mdrt.low.name = "Low",
  mdrt.mid.name = NULL,
  mdrt.high.name = "High",
  y.high.lim = NULL,
  y.low.lim = NULL,
  spline_labels = c("LHS", "RHS")
)
}
\arguments{
\item{reg.coef}{a coefficient matrix of regression result, e.g. summary(lm_model)$coef}

\item{data}{the data used in regression, a data frame}

\item{model}{the model object, such as a "lm" object}

\item{by_color}{plot interactions by colors, otherwise by line types}

\item{x_var.name}{x name in the regression model, a string}

\item{y_var.name}{y name in the regression model, a string}

\item{moderator.name}{moderating variable name in the regression model, a string}

\item{min_x}{the min of x scale, in percentile of x}

\item{max_x}{the max of x scale, in percentile of x}

\item{mdrt_quantile_05}{set the low level of moderator, in percentile}

\item{mdrt_quantile_50}{set the middle level of moderator, in percentile}

\item{mdrt_quantile_95}{set the high level of moderator, in percentile}

\item{mod.n.sd}{set the moderating strength, in the number of s.d. units, which can take negative values}

\item{confidence_interval}{if TRUE, plot confidence intervals}

\item{v}{a customized variance-covariance matrix}

\item{CI_Ribbon}{if TRUE, plot confidence interval ribbons, if FALSE, plot error bars}

\item{title}{the title of the plot}

\item{xlab}{label of X}

\item{ylab}{label of Y}

\item{moderator.lab}{label of moderator}

\item{mdrt.low.name}{the label of low-level moderator}

\item{mdrt.mid.name}{the label of mid-level moderator}

\item{mdrt.high.name}{the label of high-level moderator}

\item{y.high.lim}{specify the upper limit of y}

\item{y.low.lim}{specify the lower limit of y}

\item{spline_labels}{label of the spline variable}
}
\description{
plotting the marginal effect of X on Y, with or without one or multiple interaction terms
}
\examples{
data(mtcars)
m1 <- lm(mpg ~ vs + carb + hp + wt + wt * hp , data = mtcars)
plot_effect(reg.coef = summary(m1)$coefficients,
                 data = mtcars, model = m1,
                 x_var.name = "wt", y_var.name = "mpg", moderator.name = "hp",
                 confidence_interval = TRUE,  CI_Ribbon = TRUE,
                 xlab = "Weight", ylab = "MPG", moderator.lab = "Horsepower")

#' @examples
data(mtcars)
m2 <- lm(mpg ~ vs + carb + hp + wt + wt * hp + wt * vs, data = mtcars)
plot_effect(reg.coef = summary(m2)$coefficients,
            data = mtcars, model = m2,
            x_var.name = "wt", y_var.name = "mpg", moderator.name = "hp",
            confidence_interval = TRUE,  CI_Ribbon = FALSE,
            xlab = "Weight", ylab = "MPG", moderator.lab = "Horsepower")

\dontrun{
# this shows the function is compatible with ggplot2 customization
library(extrafont)
m1 <- lm(mpg ~ vs + carb + hp + wt + wt * hp , data = mtcars)
plot_effect(reg.coef = summary(m1)$coefficients, 
                 data = mtcars, model = m1, 
                 x_var.name = "wt", y_var.name = "mpg", moderator.name = "hp", 
                 confidence_interval = TRUE,  CI_Ribbon = TRUE, 
                 xlab = "Weight", ylab = "MPG", moderator.lab = "Horsepower") + 
ggplot2::theme(text=ggplot2::element_text(family="Times New Roman", size = 16))
}

}
