% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorRate.R
\name{errorRate}
\alias{errorRate}
\title{Returns the false positive or false negative rates for a set of IBS and/or
KI thresholds}
\usage{
errorRate(simResults, bIBS = TRUE, bKI = FALSE, rel = "UN",
  IBSthresh = 14:17, KIthresh = c(1000, 10000, 1e+05, 1e+06), nLoci = 13)
}
\arguments{
\item{simResults}{A data.frame with three columns labelled sib, pc and ibs.
This will usually be obtained from a call to \code{sim} or
\code{readResults}.}

\item{bIBS}{If \code{TRUE} then IBS thresholds are used to generate the
error rates. If both \code{bIBS} and \code{bKI} are \code{TRUE} then both
criteria are used.}

\item{bKI}{If \code{TRUE} then KI thresholds are used to generate the error
rates. If both \code{bIBS} and \code{bKI} are \code{TRUE} then both criteria
are used.}

\item{rel}{The relationship used in the simulation. Must be one of 'UN',
'FS' or 'PC'.}

\item{IBSthresh}{A vector of IBS values that can be used to classify the
results as being related (or not).}

\item{KIthresh}{A vector of KI threshold values that can be used to classify
the results as being related (or not).}

\item{nLoci}{The number of loci being used in the multiplex. This dictates
the upper bound on the IBS values.}
}
\value{
A vector (or a two-column matrix) of false negative or false
positive rates. If the relationship is 'UN' then false positive rates are
returned for parent-child and full-sibs, with parent-child being in column 1
and full-sibs in column 2. If the relationship is 'PC' then the false
negative rate is returned for parent-child pairs, and if it is 'FS' then the
false negative rate for full-sibs.
}
\description{
This function is used to calcalate the various tables in the work of Ge et
al. and Balding et al. Specifically it can be used to calculate the false
positive rate for unrelated pairs being identified as full-sibs or
parent-child pairs under differing levels of IBS or KI (or both) thresholds.
It can also be used to calculate the false negative rates for full-sib, or
parent-child, pairs being identified as unrelated, again with differing
levels of IBS, KI or both.
}
\examples{

## not run
\dontrun{data(fbiCaucs)
unrel = sim(10000)
errorRate(unrel)
}

}
\seealso{
sim, readResults
}
\author{
James M. Curran
}
