% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp4.R
\name{to_mp4}
\alias{to_mp4}
\title{Render slides as an MP4 video file.}
\usage{
to_mp4(
  from,
  to = NULL,
  density = 100,
  slides = "all",
  fps = 1,
  complex_slides = FALSE,
  partial_slides = FALSE,
  delay = 1,
  keep_intermediates = FALSE
)
}
\arguments{
\item{from}{Path to an \code{.Rmd}, \code{.qmd}, \code{.html}, \code{.pdf} file, or a URL. If
\code{from} is a URL to slides on a website, you must provide the full URL
ending in \code{".html"}.}

\item{to}{Name of the output \code{.mp4} file.}

\item{density}{Resolution of the resulting PNGs in each slide file. Defaults
to \code{100}.}

\item{slides}{A numeric or integer vector of the slide number(s) to include
in the mp4, or one of \code{"all"}, \code{"first"}, or \code{"last"}. Negative integers
select which slides \emph{not} to include. Defaults to \code{"all"}, in which case
all slides are included.}

\item{fps}{Frames per second of the resulting \code{.mp4} file.}

\item{complex_slides}{For "complex" slides (e.g. slides with panelsets or
other html widgets or advanced features), set \code{complex_slides = TRUE}.
Defaults to \code{FALSE}. This will use the {chromote} package to iterate
through the slides at a pace set by the \code{delay} argument. Requires a local
installation of Chrome.}

\item{partial_slides}{Should partial (continuation) slides be included in the
output? If \code{FALSE}, the default, only the complete slide is included in the
PDF.}

\item{delay}{Seconds of delay between advancing to and printing a new slide.
Only used if \code{complex_slides = TRUE} or \code{partial_slides = TRUE}.}

\item{keep_intermediates}{Should we keep the intermediate files used to
render the final output? The default is \code{FALSE}.}
}
\value{
Slides are rendered as an \code{.mp4} file.
}
\description{
Render slides as an MP4 video file. The function renders to the pdf,
converts each slide in the pdf to a png, and then converts the deck of
png files to a MP4 video file.
}
\examples{
with_example("slides.Rmd", requires_chrome = TRUE, requires_packages = "av", {
    # Render mp4 from Rmd, html, pdf, or direct URL
    to_mp4("slides.Rmd")
})
}
