% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Initialize a Project}
\usage{
init(
  project = NULL,
  ...,
  profile = NULL,
  settings = NULL,
  bare = FALSE,
  force = FALSE,
  restart = interactive()
)
}
\arguments{
\item{project}{The project directory. The \R working directory will be
changed to match the requested project directory.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{profile}{The profile to be activated. When \code{NULL}, the default
profile is activated instead. See \code{vignette("profiles", package = "renv")}
for more information.}

\item{settings}{A list of \link{settings} to be used with the newly-initialized
project.}

\item{bare}{Boolean; initialize the project without attempting to discover
and install R package dependencies?}

\item{force}{Boolean; force initialization? By default, \code{renv} will refuse
to initialize the home directory as a project, to defend against accidental
mis-usages of \code{init()}.}

\item{restart}{Boolean; attempt to restart the \R session after initializing
the project? A session restart will be attempted if the \code{"restart"} \R
option is set by the frontend embedding \R.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Discover packages used within the current project, and then initialize a
project-local private \R library with those packages. The currently-installed
versions of any packages in use (as detected within the default R libraries)
are then installed to the project's private library.
}
\details{
The primary steps taken when initializing a new project are:
\enumerate{
\item \R package dependencies are discovered within the \R files used within
the project with \code{\link[=dependencies]{dependencies()}};
\item Discovered packages are copied into the \code{renv} global package cache, so
these packages can be re-used across future projects as necessary;
\item Any missing \R package dependencies discovered are then installed into
the project's private library;
\item A lockfile capturing the state of the project's library is created
with \code{\link[=snapshot]{snapshot()}};
\item The project is activated with \code{\link[=activate]{activate()}}.
}

This mimics the workflow provided by \code{packrat::init()}, but with a few
differences -- in particular, \code{renv} does not attempt to download and store
package sources, and \code{renv} will re-use packages that have already been
installed whenever possible.

If \code{renv} sees that the associated project has already been initialized and
has a lockfile, then it will attempt to infer the appropriate action to take
based on the presence of a private library. If no library is available,
\code{renv} will restore the private library from the lockfile; if one is
available, \code{renv} will ask if you want to perform a 'standard' init,
restore from the lockfile, or activate the project without taking any
further action.
}
\section{Infrastructure}{


\code{renv} will write or amend the following files in the project:
\itemize{
\item \code{.Rprofile}: An auto-loader will be installed, so that new R sessions
launched within the project are automatically loaded.
\item \code{renv/activate.R}: This script is run by the previously-mentioned
\code{.Rprofile} to load the project.
\item \code{renv/.gitignore}: This is used to instruct Git to ignore the project's
private library, as it should normally not be committed to a version
control repository.
\item \code{.Rbuildignore}: to ensure that the \code{renv} directory is ignored during
package development; e.g. when attempting to build or install a package
using \code{renv}.
}
}

\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
