% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lockfile-api.R
\name{lockfile-api}
\alias{lockfile-api}
\alias{lockfile}
\title{Programmatically Create and Modify a Lockfile}
\usage{
lockfile(file = NULL, project = NULL)
}
\arguments{
\item{file}{The path to an existing lockfile. When no lockfile is provided,
a new one will be created based on the current project context. If you
want to create a blank lockfile, use \code{file = NA} instead.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\description{
This function provides an API for creating and modifying \code{renv} lockfiles.
This can be useful when you'd like to programmatically generate or modify
a lockfile -- for example, because you want to update or change a package
record in an existing lockfile.
}
\examples{

\dontrun{

lock <- lockfile("renv.lock")

# set the repositories for a lockfile
lock$repos(CRAN = "https://cran.r-project.org")

# depend on digest 0.6.22
lock$add(digest = "digest@0.6.22")

# write to file
lock$write("renv.lock")

}

}
\seealso{
\code{\link{lockfiles}}, for a description of the structure of an
\code{renv} lockfile.
}
\keyword{internal}
