\name{zmat_sim}
\alias{zmat_sim}
\docType{data}
\title{
Simulated data set 
}
\description{
A simulated data set from three studies, with 10000 "features" in each study, each of which yielded a z-score. The data comprises 10000x3 z-scores.
See \code{\link{hmat_sim}} for the indicators of association status matrix.
}
\usage{data(zmat_sim)}
\format{
\code{zmat_sim} is a matrix of 10000 z-scores (in rows) in each of the 3 studies (columns).
}
\examples{
data(zmat_sim)
head(zmat_sim)

\dontrun{
  input.to.repfdr <- ztobins(zmat_sim, 2)
  pbz_sim1 <- input.to.repfdr$pdf.binned.z
  bz_sim1  <- input.to.repfdr$binned.z.mat
  
  data(binned_zmat_sim)
  stopifnot(all.equal(pbz_sim1,pbz_sim))
  stopifnot(all.equal(bz_sim1,bz_sim))
}

#### zmat_sim was generated by the following code:
data(hmat_sim)
set.seed(12)
m <- nrow(hmat_sim)
zmat_sim1  <- matrix(rnorm(n=3*m,mean=hmat_sim*3),nrow=m,ncol=3)
data(zmat_sim)
stopifnot(all.equal(zmat_sim1,zmat_sim))
}
\keyword{datasets}
\keyword{Replicability}
\keyword{GWAS}

