% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_copy}
\alias{repo_copy}
\title{Copy items to another repository}
\usage{
repo_copy(destrepo, name, tags = NULL, replace = F, confirm = T)
}
\arguments{
\item{destrepo}{An object of class repo (will copy to it)}

\item{name}{The name (or list of names) of the item/s to copy}

\item{tags}{If not NULL, copy all items matching tags. NULL by
default.}

\item{replace}{What to do if item exists in destination repo (see
put). F by default.}

\item{confirm}{If F, don't ask for confirmation when multiple items
are involved. F by default.}
}
\value{
Used for side effects.
}
\description{
Copies an object file from one repository to another and creates a new entry
in the index of the destination repository. Supports tags and multiple names.
}
\examples{
## Repository creation
rp_path1 <- file.path(tempdir(), "example_repo1")

rp1 <- repo_open(rp_path1, TRUE)
rp1$put(0, "item1", "A sample item", "tag1")
rp_path2 <- file.path(tempdir(), "example_repo2")
rp2 <- repo_open(rp_path2, TRUE)
rp1$copy(rp2, "item1")

## wiping temporary repo
unlink(rp_path1, TRUE)
unlink(rp_path2, TRUE)
}
