% Generated by roxygen2 (4.0.2): do not edit by hand
\name{format_timedata}
\alias{format_timedata}
\title{Format time data}
\usage{
format_timedata(data, levels = NULL, scenario = NULL, day.steps = 24)
}
\arguments{
\item{data}{Data frame with the load and VG time series (see details for requirements)}

\item{levels}{Optional data frame that contains levels of aggregation, e.g., BAA, transmission
area or interconnection (see details for requirements)}

\item{scenario}{Name of columns in \code{data} used to denote different scenarios}

\item{day.steps}{Number of data points in a day (defaults to 24)}
}
\value{
A data frame with load and VG data aggregated by scenario and different areas and levels of aggregation
}
\description{
Create valid data container that has aggregated load and variable generation (VG) time series for
different areas and levels of aggregation.
}
\details{
The columns identified by \code{scenario} are used to perform calculations separately. This way one can run
different sensitivities in the same calculation (e.g., to estimate the capacity value of wind with different
penetration levels).

Requirements for \code{data}:
\itemize{
  \item{The number of entries needs to be a multiple of \code{day.steps}}
  \item{A \code{Time} column that can be ordered (integer or time stamps)}
  \item{A \code{Load} column with load time series}
  \item{No column named \code{Level}, \code{NetLoad} or \code{VG} (they are reserved name)}
  \item{Optionally, if a column called \code{Area} exists, it will be used to separate areas}
  \item{All columns must contain numbers except for \code{Time}, \code{Area} and those in \code{scenario}}
}

Requirements for \code{levels}:
\itemize{
  \item{This parameter is optional}
  \item{If \code{levels} is provided, \code{data} must contain a column called \code{Area}}
  \item{The first column must contain the most granular level of data}
  \item{The column names in \code{levels} will become the names of the different levels of aggregation}
}
}
\examples{
# Create data for two days
tdata <- data.frame(Area = c(rep("A", 48), rep("B", 48)),
                    Time = 1:48,
                    Load = c(runif(48, 200, 250), runif(48, 400, 450)),
                    Wind = c(runif(48, 20, 25), runif(48, 40, 45)))
levs <- data.frame(BAA = c("A", "B"), Region = c("All", "All"))

# Format time data without and with different levels of aggregation
td1 <- format_timedata(tdata)
head(td1)
td2 <- format_timedata(tdata, levs)
head(td2)

# Format time data with a scenario column
tdata2 <- tdata
tdata2$Scenario <- "Scenario 1"
td3 <- format_timedata(tdata2, scenario = "Scenario")
head(td3)

# Format time data without Area column (minimum example)
tdata3 <- tdata
tdata2$Area <- NULL
td4 <- format_timedata(tdata3)
head(td4)
}
\seealso{
\code{\link{outage_table}} is the function that creates outage tables

\code{\link{sliding_window}} is used internally by several functions to extend
         time data objects
}

