% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{PHat.test}
\alias{PHat.test}
\title{PHat.test}
\usage{
PHat.test(x, y, alpha = 0.05, alternative = "two.sided", sigfig = -1)
}
\arguments{
\item{x}{The data from one group}

\item{y}{The data from the alternative group}

\item{alpha}{The significance level of tests which also controls the values
of the confidence interval (default 0.05)}

\item{alternative}{This defines whether a one-sided test or a two-sided
(default) test is required. For a one-sided test use parameter values
greater' or 'less' to define whether the d-value should be greater or less
than zero.}

\item{sigfig}{is the number of significant digits in the data.}
}
\value{
The values of phat and its standard error,the t-value, its pvalue and the upper and lower confidence interval.
}
\description{
This function provides single-sided and two-sided tests of the probability of superiority (phat).
}
\examples{
set.seed(456)
x <- rnorm(10, 0, 1)
y <- rnorm(10, 0.8, 1)
PHat.test(x, y, alpha = .05, alternative = "greater", sigfig = -1)
# A tibble: 1 x 8
#    phat sqse.phat phat.df phat.tvalue phat.pvalue phat.ci.lower phat.ci.upper phat.sig
#   <dbl>     <dbl>   <dbl>       <dbl>       <dbl>         <dbl>         <dbl> <lgl>
# 1  0.79    0.0118    13.6        2.67     0.00924         0.599             1 TRUE
PHat.test(x, y, alpha = .05, alternative = "two.sided", sigfig = -1)
# A tibble: 1 x 8
# phat sqse.phat phat.df phat.tvalue phat.pvalue phat.ci.lower phat.ci.upper phat.sig
#  <dbl>     <dbl>   <dbl>       <dbl>       <dbl>         <dbl>         <dbl> <lgl>
# 1  0.79    0.0118    13.6        2.67      0.0185         0.557             1 TRUE

}
\author{
Barbara Kitchenham and Lech Madeyski
}
