% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parsers}
\alias{parsers}
\alias{parse_json}
\alias{parse_plain}
\alias{parse_xml}
\alias{parse_html}
\alias{parse_multiform}
\alias{parse_queryform}
\alias{parse_table}
\title{Pre-supplied parsing generators}
\usage{
parse_json(simplifyVector = TRUE, simplifyDataFrame = simplifyVector,
  simplifyMatrix = simplifyVector, flatten = FALSE)

parse_plain(sep = "\\n")

parse_xml(encoding = "", options = "NOBLANKS", base_url = "")

parse_html(encoding = "", options = c("RECOVER", "NOERROR",
  "NOBLANKS"), base_url = "")

parse_multiform()

parse_queryform()

parse_table(...)
}
\arguments{
\item{simplifyVector}{coerce JSON arrays containing only primitives into an atomic vector}

\item{simplifyDataFrame}{coerce JSON arrays containing only records (JSON objects) into a data frame}

\item{simplifyMatrix}{coerce JSON arrays containing vectors of equal mode and dimension into matrix or array}

\item{flatten}{automatically \code{\link{flatten}} nested data frames into a single non-nested data frame}

\item{sep}{The line separator. Plain text will be split into multiple strings
based on this.}

\item{encoding}{Specify a default encoding for the document. Unless
otherwise specified XML documents are assumed to be in UTF-8 or
UTF-16. If the document is not UTF-8/16, and lacks an explicit
encoding directive, this allows you to supply a default.}

\item{options}{Set parsing options for the libxml2 parser. Zero of more of
\describe{
  \item{RECOVER}{recover on errors}
  \item{NOENT}{substitute entities}
  \item{DTDLOAD}{load the external subset}
  \item{DTDATTR}{default DTD attributes}
  \item{DTDVALID}{validate with the DTD}
  \item{NOERROR}{suppress error reports}
  \item{NOWARNING}{suppress warning reports}
  \item{PEDANTIC}{pedantic error reporting}
  \item{NOBLANKS}{remove blank nodes}
  \item{SAX1}{use the SAX1 interface internally}
  \item{XINCLUDE}{Implement XInclude substitition}
  \item{NONET}{Forbid network access}
  \item{NODICT}{Do not reuse the context dictionary}
  \item{NSCLEAN}{remove redundant namespaces declarations}
  \item{NOCDATA}{merge CDATA as text nodes}
  \item{NOXINCNODE}{do not generate XINCLUDE START/END nodes}
  \item{COMPACT}{compact small text nodes; no modification of the tree allowed afterwards (will possibly crash if you try to modify the tree)}
  \item{OLD10}{parse using XML-1.0 before update 5}
  \item{NOBASEFIX}{do not fixup XINCLUDE xml:base uris}
  \item{HUGE}{relax any hardcoded limit from the parser}
  \item{OLDSAX}{parse using SAX2 interface before 2.7.0}
  \item{IGNORE_ENC}{ignore internal document encoding hint}
  \item{BIG_LINES}{Store big lines numbers in text PSVI field}
}}

\item{base_url}{When loading from a connection, raw vector or literal
html/xml, this allows you to specify a base url for the document. Base
urls are used to turn relative urls into absolute urls.}

\item{...}{parameters passed on to \code{\link[=read.table]{read.table()}}}
}
\value{
A function accepting a raw vector and a named list of directives
}
\description{
This set of functions can be used to construct parsing functions adhering to
the Request$parse() requirements.
}
\examples{
fake_rook <- fiery::fake_request(
  'http://example.com/test',
  content = '[1, 2, 3, 4]',
  headers = list(
    Content_Type = 'application/json'
  )
)

req <- Request$new(fake_rook)
req$parse(json = parse_json())
req$body

# Cleaning up connections
rm(fake_rook, req)
gc()

}
\seealso{
\link{formatters} for converting \code{Response} bodies into compatible types

\link{default_parsers} for a list that maps the most common mime types
to their respective parsers
}
