% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/res_rel_vul.R
\name{rrv}
\alias{rrv}
\title{Reliability, resilience, and vulnerability analysis}
\usage{
rrv(Q, R_target, capacity, double_cycle = FALSE, plot = TRUE,
  S_initial = 1, policy = NULL)
}
\arguments{
\item{Q}{time series or vector. The net inflows to the reservoir.}

\item{R_target}{time series or vector. The target release. Must be the same length as Q.}

\item{capacity}{numerical. The reservoir capacity. Should be same volumetric unit as Q and R.}

\item{double_cycle}{logical. If TRUE the input series will be replicated and placed end-to-end to double the simulation. (Recommended if the critical period occurs at the end of the recorded inflow time series)}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{policy}{list. The output of the SDP function. The default is (NULL) is Standard Operating Policy.}
}
\value{
Returns reliability, resilience and vulnerability metrics based on supply deficits.
}
\description{
Computes time-based, annual, and volumetric reliability, as well as resilience and dimensionless vulnerability for a single reservoir.
}
\examples{
# Determine the reliability, resilience and vulnerability for reservoir on Holland Creek
demand <- rep(0.8 * mean(ResX_inflow.ts), length = length(ResX_inflow.ts))
storage_cap <- 2*mean(aggregate(ResX_inflow.ts))  # 2 years' storage
rrv(ResX_inflow.ts, R_target = demand, capacity = storage_cap)
}
\references{
McMahon, T.A., Adeloye, A.J., Zhou, S.L. (2006) Understanding performance measures of reservoirs, Journal of Hydrology 324 (359-382)
}

