% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mixture.R
\name{fit_mixture}
\alias{fit_mixture}
\title{Fit a generic mixture using an ECME-Algorithm}
\usage{
fit_mixture(
  dist,
  obs,
  start,
  min_iter = 0L,
  max_iter = 100L,
  skip_first_e = FALSE,
  tolerance = 1e-05,
  trace = FALSE,
  ...
)
}
\arguments{
\item{dist}{A \code{MixtureDistribution} specifying the structure of the mixture.
Free parameters are to be optimised. The dominating measure for likelihoods
must be constant, so for example \code{\link[=dist_dirac]{dist_dirac()}} may not have its \code{point}
parameter free.}

\item{obs}{Set of observations as produced by \code{\link[=trunc_obs]{trunc_obs()}} or convertible
via \code{\link[=as_trunc_obs]{as_trunc_obs()}}.}

\item{start}{Initial values of all placeholder parameters.
If missing, starting values are obtained from \code{\link[=fit_dist_start]{fit_dist_start()}}.}

\item{min_iter}{Minimum number of EM-Iterations}

\item{max_iter}{Maximum number of EM-Iterations (weight updates)}

\item{skip_first_e}{Skip the first E-Step (update Probability weights)?
This can help if the initial values cause a mixture component to vanish in
the first E-Step before the starting values can be improved.}

\item{tolerance}{Numerical tolerance.}

\item{trace}{Include tracing information in output?
If \code{TRUE}, additional tracing information will be added to the result list.}

\item{...}{Passed to \code{\link[=fit_dist_start]{fit_dist_start()}} if \code{start} is missing.}
}
\value{
A list with elements
\itemize{
\item \code{params} the fitted parameters in the same structure as \code{init}.
\item \code{params_hist} (if \code{trace} is TRUE) the history of parameters
(after each e- and m- step)
\item \code{iter} the number of outer EM-iterations
\item \code{logLik} the final log-likelihood
}
}
\description{
Fit a generic mixture using an ECME-Algorithm
}
\examples{
dist <- dist_mixture(
  list(
    dist_dirac(0.0),
    dist_exponential()
  )
)

params <- list(
  probs = list(0.1, 0.9),
  dists = list(
    list(),
    list(rate = 1.0)
  )
)

x <- dist$sample(100L, with_params = params)

fit_mixture(dist, x)

}
\seealso{
Other distribution fitting functions: 
\code{\link{fit_blended}()},
\code{\link{fit_dist}()},
\code{\link{fit_erlang_mixture}()}
}
\concept{distribution fitting functions}
