% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closed.R
\encoding{UTF-8}
\name{closed}
\alias{closed}
\title{Closed respirometry}
\usage{
closed(MO2, delta_pO2, duration, vol, temp = 25, sal = 35,
  atm_pres = 1013.25)
}
\arguments{
\item{MO2}{whole-animal oxygen consumption rate (umol / hour).}

\item{delta_pO2}{desired change in pO2 (\% air saturation).}

\item{duration}{desired duration to reach \code{delta_pO2} (minutes).}

\item{vol}{volume of the respirometer (liter).}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\description{
Returns the unknown parameter given 3 of 4 parameters to calculate respiration rate in a closed respirometer. This is useful both for basic closed respirometry setups, and also for the closed measurement phase of intermittent respirometry.
}
\examples{
# I've read in the literature that my animal has an SMR of 200 umol/h. How large of a
# respirometer do I want if I want it to breathe down to 80\% air saturation in 30 minutes?
closed(MO2 = 200, delta_pO2 = 100 - 80, duration = 30) # returns respirometer volume

# I've read in the literature that my animal has an SMR of 1000 umol/h. How long will it take to
# breathe down a 50 L respirometer by 10\% air saturation?
closed(MO2 = 1000, delta_pO2 = 10, vol = 50) # returns the duration to breathe down the O2

# How does animal size affect how long my measurement periods last?
mass_range = seq(100, 400, 50)
dur_range = (closed(MO2 = scale_MO2(mass_1 = 100, MO2_1 = 400, mass_2 = mass_range)$MO2_2,
 delta_pO2 = 20, vol = 10))
plot(mass_range, dur_range, type = 'b')

# What is the MO2 if O2 drops 0.44 mg/l in 33 minutes when the respirometer volume is 30 L?
closed(delta_pO2 = conv_o2(o2 = 0.44, from = 'mg_per_l', to = 'percent_a.s.'), duration = 33,
 vol = 30)

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\seealso{
\code{\link{flush_water}}
}

