% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_o2.R
\encoding{UTF-8}
\name{conv_o2}
\alias{conv_o2}
\title{Convert between units of oxygen partial pressure and concentration}
\usage{
conv_o2(o2 = 100, from = "percent_a.s.", to = "all", temp = 25,
  sal = 35, atm_pres = 1013.25)
}
\arguments{
\item{o2}{a numeric vector of the O2 value(s). Default is 100.}

\item{from}{a string describing the unit used to measure \code{o2}. Default is "percent_a.s." Options are:\itemize{
\item{percent_a.s. (percent air saturation)}{}
\item{percent_o2}{}
\item{hPa}{}
\item{kPa}{}
\item{torr}{}
\item{mmHg}{}
\item{inHg}{}
\item{mg_per_l}{}
\item{umol_per_l}{}
\item{mmol_per_l}{}
\item{ml_per_l}{}
\item{mg_per_kg}{}
\item{umol_per_kg}{}
\item{mmol_per_kg}{}
\item{ml_per_kg}{}
}}

\item{to}{a single string either describing the unit to which the conversion should be conducted (options are the same as in \code{from}), or the string "all" to return all units.}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\description{
Unfortunately, a consensus on the best way to express how much oxygen is in water has not been formed to date. Until then, this function converts between all commonly used forms of dissolved O2 measurements.
}
\details{
Conversions are based on relationships and values from the package \code{\link[marelac]{marelac}}.
}
\examples{
conv_o2(o2 = 50)
conv_o2(o2 = 1:50, from = "umol_per_l", to = "ml_per_l", temp = 10, sal = 0,
	atm_pres = 1100)
conv_o2()[c('mmHg','kPa')]

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}

