% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data.R
\name{extract_data}
\alias{extract_data}
\title{Extract data values from SDMX XML}
\usage{
extract_data(xml_lf, keep_flags = FALSE,
  stringsAsFactors = default.stringsAsFactors())
}
\arguments{
\item{xml_lf}{an XML leaf with data series from an SDMX XML file}

\item{keep_flags}{a boolean if to extract the observation status (flag) information from the XML file. The default value is \code{FALSE}}

\item{stringsAsFactors}{if \code{TRUE} (the default) the columns are
converted to factors. If \code{FALSE} they are returned as a character.}
}
\value{
a data frame with
}
\description{
Extracts the data values from the SDMX XML data file
}
\details{
It is a subfunction to use in the \code{\link{get_eurostat_data}} function.
}
\examples{
\dontshow{
options(mc.cores=min((parallel::detectCores()),2))
}
\donttest{
id<-"agr_r_milkpr"
toc<-get_eurostat_toc()
bulk_url<-toc$downloadLink.sdmx[toc$code==id]
temp<-tempfile()
download.file(bulk_url,temp)
sdmx_xml<-xml2::read_xml(unzip(temp, paste0(id,".sdmx.xml")))
xml_leafs<-xml2::xml_find_all(sdmx_xml,".//data:Series")
extract_data(xml_leafs[1])
}

}
