/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;

public class TuplesLargeTable
extends LargeRelation {
    private final int n;
    private final TIntObjectHashMap<TIntSet> tables;
    private final int[] lowerbounds;
    private final int[] upperbounds;
    private final boolean feasible;
    private final long[] blocks;

    public TuplesLargeTable(Tuples tuples, IntVar[] vars) {
        this.n = vars.length;
        this.lowerbounds = new int[this.n];
        this.upperbounds = new int[this.n];
        this.feasible = tuples.isFeasible();
        this.blocks = new long[this.n];
        long totalSize = 1L;
        for (int i = 0; i < this.n; ++i) {
            this.blocks[i] = totalSize;
            this.lowerbounds[i] = vars[i].getLB();
            this.upperbounds[i] = vars[i].getUB();
            if ((totalSize *= (long)(this.upperbounds[i] - this.lowerbounds[i] + 1)) >= 0L) continue;
            totalSize = -1L;
        }
        if (totalSize / Integer.MAX_VALUE + 1L < 0L || totalSize / Integer.MAX_VALUE + 1L > Integer.MAX_VALUE) {
            throw new SolverException("Tuples required too much memory ...");
        }
        this.tables = new TIntObjectHashMap();
        int nt = tuples.nbTuples();
        for (int i = 0; i < nt; ++i) {
            int[] tuple = tuples.get(i);
            if (!this.valid(tuple, vars)) continue;
            this.setTuple(tuple);
        }
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        long address = 0L;
        for (int i = this.n - 1; i >= 0; --i) {
            if (tuple[i] < this.lowerbounds[i] || tuple[i] > this.upperbounds[i]) {
                return false;
            }
            address += (long)(tuple[i] - this.lowerbounds[i]) * this.blocks[i];
        }
        int a2 = (int)(address % Integer.MAX_VALUE);
        int t = (int)(address / Integer.MAX_VALUE);
        TIntSet ts = this.tables.get(t);
        return ts != null && ts.contains(a2);
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return this.checkTuple(tuple) == this.feasible;
    }

    private void setTuple(int[] tuple) {
        long address = 0L;
        for (int i = this.n - 1; i >= 0; --i) {
            address += (long)(tuple[i] - this.lowerbounds[i]) * this.blocks[i];
        }
        int a2 = (int)(address % Integer.MAX_VALUE);
        int t = (int)(address / Integer.MAX_VALUE);
        TIntSet ts = this.tables.get(t);
        if (ts == null) {
            ts = new TIntHashSet();
            this.tables.put(t, ts);
        }
        ts.add(a2);
    }

    @Override
    public Tuples convert() {
        Tuples tuples = new Tuples(this.feasible);
        int[] tt = new int[this.lowerbounds.length];
        for (TIntSet set : this.tables.valueCollection()) {
            for (int add : set.toArray()) {
                for (int i = this.n - 1; i >= 0; --i) {
                    long t = (long)add / this.blocks[i];
                    tt[i] = (int)(t + (long)this.lowerbounds[i]);
                    add = (int)((long)add - t);
                }
            }
            tuples.add(tt);
        }
        return tuples;
    }
}

