% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python-packages.R
\name{configure_environment}
\alias{configure_environment}
\title{Configure a Python Environment}
\usage{
configure_environment(package = NULL, force = TRUE)
}
\arguments{
\item{package}{The name of a package to configure. When \code{NULL}, \code{reticulate}
will instead look at all loaded packages and discover their associated
Python requirements.}

\item{force}{Boolean; force configuration of the associated environment?}
}
\description{
Configure a Python environment, satisfying the Python dependencies of any
loaded \R packages.
}
\details{
Normally, this function should only be used by package authors, who want
to ensure that their package dependencies are installed in the active
Python environment. For example:\preformatted{.onLoad <- function(libname, pkgname) \{
  reticulate::configure_environment(pkgname)
\}
}

If the Python session has not yet been initialized, or if the user is not
using the default Miniconda Python installation, no action will be taken.
Otherwise, \code{reticulate} will take this as a signal to install any required
Python dependencies into the user's Python environment.

If you'd like to disable \code{reticulate}'s auto-configure behavior altogether,
you can set the environment variable:\preformatted{RETICULATE_AUTOCONFIGURE = FALSE
}

e.g. in your \verb{~/.Renviron} or similar.

Note that, in the case where the Python session has not yet been initialized,
\code{reticulate} will automatically ensure your required Python dependencies
are installed after the Python session is initialized (when appropriate).
}
