% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_waves.R
\name{harmonize_waves}
\alias{harmonize_waves}
\title{Harmonize waves}
\usage{
harmonize_waves(waves, .f, status_message = FALSE)
}
\arguments{
\item{waves}{A list of surveys}

\item{.f}{A function to apply for the harmonization.}

\item{status_message}{Defaults to \code{FALSE}. If set to \code{TRUE}
it shows the id of the survey that is being joined.}
}
\value{
A natural full join of all surveys in a single data frame.
}
\description{
Harmonize the values of surveys.
}
\details{
The functions binds together variables
that are all present in the surveys, and applies a 
harmonization function \code{.f} on them.
}
\examples{
\donttest{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_list <- dir(examples_dir)[grepl("\\\\.rds", dir(examples_dir))]

example_surveys <- read_surveys(
  file.path( examples_dir, survey_list), 
  save_to_rds = FALSE)

metadata <- lapply ( X = example_surveys, FUN = metadata_create )
metadata <- do.call(rbind, metadata)

to_harmonize <- metadata \%>\%
  dplyr::filter ( var_name_orig \%in\% 
                  c("rowid", "w1") |
                  grepl("trust ", label_orig ) ) \%>\%
  dplyr::mutate ( var_label = var_label_normalize(label_orig)) \%>\%
  dplyr::mutate ( var_name = val_label_normalize(var_label))

harmonize_eb_trust <- function(x) {
  label_list <- list(
    from = c("^tend\\\\snot", "^cannot", "^tend\\\\sto", "^can\\\\srely",
             "^dk", "^inap", "na"), 
   to = c("not_trust", "not_trust", "trust", "trust",
           "do_not_know", "inap", "inap"), 
    numeric_values = c(0,0,1,1, 99997,99999,99999)
  )
  
  harmonize_values(x, 
                   harmonize_labels = label_list, 
                   na_values = c("do_not_know"=99997,
                                 "declined"=99998,
                                 "inap"=99999)
                   )
}

merged_surveys <- merge_waves ( example_surveys, var_harmonization = to_harmonize  )

harmonized <- harmonize_waves(waves = merged_surveys, 
                              .f = harmonize_eb_trust,
                              status_message = FALSE)
                              
# For details see Afrobarometer and Eurobarometer Case Study vignettes.
}
}
\seealso{
Other harmonization functions: 
\code{\link{collect_val_labels}()},
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_values}()},
\code{\link{harmonize_var_names}()},
\code{\link{label_normalize}()},
\code{\link{merge_waves}()},
\code{\link{na_range_to_values}()},
\code{\link{suggest_permanent_names}()},
\code{\link{suggest_var_names}()}
}
\concept{harmonization functions}
