% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{survey}
\alias{survey}
\alias{is.survey}
\title{Survey data frame}
\usage{
survey(
  df = data.frame(),
  id = character(),
  filename = character(),
  doi = character()
)

is.survey(df)
}
\arguments{
\item{df}{A tibble or data frame that contains the survey data.}

\item{id}{A mandatory identifier for the survey}

\item{filename}{The import file name.}

\item{doi}{Optional doi, can be omitted.}
}
\value{
A tibble with \code{id},  \code{filename},  \code{doi} 
metadata information.
}
\description{
Store the data of a survey in a tibble (data frame) with a unique
survey identifier, import filename, and optional doi.
}
\examples{
example_survey <- survey( 
  df =data.frame ( 
    rowid = 1:6,
    observations = runif(6)), 
  id = 'example', 
  filename = "no_file"
)
}
