% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fars.R
\name{get_fars}
\alias{get_fars}
\title{Get FARS data}
\usage{
get_fars(
  years = 2014:2023,
  states = NULL,
  source = c("zenodo", "nhtsa"),
  proceed = FALSE,
  dir = NULL,
  cache = NULL
)
}
\arguments{
\item{years}{Years to be downloaded, in yyyy (character or numeric formats,
defaults to last 10 years).}

\item{states}{States to keep. Leave as NULL (the default) to keep
all states. Can be specified as full state name (e.g. "Virginia"),
abbreviation ("VA"), or FIPS code (51).}

\item{source}{The source of the data: 'zenodo' (the default) pulls the prepared
dataset from \href{https://zenodo.org/records/17162673}{Zenodo}, 'nhtsa'
pulls the raw files from NHTSA's FTP site and prepares them on your machine.
'zenodo' is much faster and provides the same dataset produced by using source='nhtsa'.}

\item{proceed}{Logical, whether or not to proceed with downloading files without
asking for user permission (defaults to FALSE, thus asking permission)}

\item{dir}{Directory in which to search for or save a 'FARS data' folder. If
NULL (the default), files are downloaded and unzipped to temporary
directories and prepared in memory. Ignored if source = 'zenodo'.}

\item{cache}{The name of an RDS file to save or use. If the specified file (e.g., 'myFARS.rds')
exists in 'dir' it will be returned; if not, an RDS file of this name will be
saved in 'dir' for quick use in subsequent calls. Ignored if source = 'zenodo'.}
}
\value{
A FARS data object (list of six tibbles: flat, multi_acc,
   multi_veh, multi_per, events, and codebook), described below.
}
\description{
Bring FARS data into the current environment, whether by downloading it anew
    or by using pre-existing files.
}
\details{
This function provides the FARS database for the specified years and states.
   By default, it pulls from a Zenodo repository for speed and memory efficiency.
   It can also pull the raw files from \href{https://www.nhtsa.gov/file-downloads?p=nhtsa/downloads/}{NHTSA} and process them in memory, or
   use an RDS file saved on your machine.

   If source = 'nhtsa' and no directory (dir) is specified, SAS files are downloaded into a
   tempdir(), where they are also prepared, combined, and then brought into
   the current environment. If you specify a directory (dir), the function will
   look there for a 'FARS data' folder. If not found, it will be created and
   populated with raw and prepared SAS and RDS files, otherwise the
   function makes sure all requested years are present and asks permission
   to download any missing years.

   The object returned is a list with class 'FARS'. It contains six tibbles:
   flat, multi_acc, multi_veh, multi_per, events, and codebook.

   Flat files are wide-formatted and presented at the person level.
   All \emph{crashes} involve at least one motor \emph{vehicle}, each of
   which may contain one or multiple \emph{people}. These are the three
   entities of crash data. The flat files therefore repeat some data elements
   across multiple rows. Please conduct your analysis with your entity in mind.

   Some data elements can include multiple values for any data level
   (e.g., multiple weather conditions corresponding to the crash, or multiple
   crash factors related to vehicle or person). These elements have been
   collected in the yyyy_multi_[acc/veh/per].rds files in long format.
   These files contain crash, vehicle, and person identifiers, and two
   variables labelled \code{name} and \code{value}. These correspond to
   variable names from the raw data files and the corresponding values,
   respectively.

   The events tibble provides a sequence of events for all vehicles involved
   in the crash. See Crash Sequences vignette for an example.

   Finally, the codebook tibble serves as a searchable codebook for all files of any given year.

   Please review the \href{https://crashstats.nhtsa.dot.gov/Api/Public/ViewPublication/813706}{FARS Analytical User's Manual}
}
\examples{

  \dontrun{
    myFARS <- get_fars(years = 2021, states = "VA")
  }
}
