% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prices.R
\name{get_prices}
\alias{get_prices}
\title{Download historic prices of a given company}
\usage{
get_prices(symbol, from = "1970-01-01", to = Sys.Date())
}
\arguments{
\item{symbol}{String that specifies the ticker/symbol of the company we want to download its prices.}

\item{from}{Minimum date to get data from.}

\item{to}{Maximum date to get data of.}
}
\value{
Returns a tibble.
}
\description{
This function retrieves all available historic prices of a given company. This company is specified using the `symbol` argument. All available symbols can be found using `get_symbols_list()`
}
\examples{

prices <- get_prices('MSFT', from = '2010-04-05', to = '2011-03-02')
}
