/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class NaiveTimeCumulFilter
extends CumulFilter {
    private int[] time = new int[31];

    public NaiveTimeCumulFilter(int nbMaxTasks) {
        super(nbMaxTasks);
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks, Propagator<IntVar> aCause) throws ContradictionException {
        int min = 0x3FFFFFFF;
        int max = -1073741824;
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int i2 = tIter.nextInt();
            if (s[i2].getUB() >= s[i2].getLB() + d[i2].getValue()) continue;
            min = Math.min(min, s[i2].getUB());
            max = Math.max(max, s[i2].getLB() + d[i2].getValue());
        }
        if (min < max) {
            int t;
            if (max - min > this.time.length) {
                this.time = new int[max - min];
            } else {
                Arrays.fill(this.time, 0, max - min, 0);
            }
            int capaMax = capa.getValue();
            tIter = tasks.iterator();
            while (tIter.hasNext()) {
                int i3 = tIter.nextInt();
                int elb = s[i3].getLB() + d[i3].getValue();
                int hlb = h[i3].getValue();
                for (t = s[i3].getUB(); t < elb; ++t) {
                    int n = t - min;
                    this.time[n] = this.time[n] + hlb;
                }
            }
            ISetIterator i3 = tasks.iterator();
            while (i3.hasNext()) {
                int i4 = (Integer)i3.next();
                if (d[i4].getValue() <= 0 || h[i4].getValue() <= 0) continue;
                if (s[i4].getLB() + d[i4].getValue() > min) {
                    this.filterInf(s[i4], d[i4].getValue(), h[i4].getValue(), min, max, this.time, capaMax, aCause);
                }
                if (s[i4].getUB() >= max) continue;
                this.filterSup(s[i4], d[i4].getValue(), h[i4].getValue(), min, max, this.time, capaMax, aCause);
            }
            OptionalInt tmax = IntStream.range(0, max - min).filter(k -> this.time[k] > capaMax).findAny();
            if (tmax.isPresent()) {
                t = tmax.getAsInt() + min;
                int[] _tasks = IntStream.range(0, s.length).filter(i -> d[i].getValue() > 0 && h[i].getValue() > 0 && s[i].getUB() <= t && t < s[i].getLB() + d[i].getValue()).toArray();
                if (_tasks.length > 0) {
                    s[_tasks[0]].updateUpperBound(t - d[_tasks[0]].getValue(), (ICause)aCause);
                } else {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void filterInf(IntVar start, int dlb, int hlb, int min, int max, int[] time, int capaMax, Propagator<IntVar> aCause) throws ContradictionException {
        int nbOk = 0;
        int sub = start.getUB();
        for (int t = start.getLB(); t < sub; ++t) {
            if (t < min || t >= max || hlb + time[t - min] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            start.updateLowerBound(t + 1, (ICause)aCause);
        }
    }

    private void filterSup(IntVar start, int dlb, int hlb, int min, int max, int[] time, int capaMax, Propagator<IntVar> aCause) throws ContradictionException {
        int nbOk = 0;
        int elb = start.getLB() + dlb;
        for (int t = start.getUB() + dlb; t > elb; --t) {
            if (t - 1 < min || t - 1 >= max || hlb + time[t - min - 1] <= capaMax) {
                if (++nbOk != dlb) continue;
                return;
            }
            nbOk = 0;
            start.updateUpperBound(t - 1 - dlb, (ICause)aCause);
        }
    }
}

