/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.knapsack.structure;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.chocosolver.solver.constraints.nary.knapsack.structure.FingerTree;
import org.chocosolver.solver.constraints.nary.knapsack.structure.InnerNode;
import org.chocosolver.solver.constraints.nary.knapsack.structure.KPItem;
import org.chocosolver.solver.constraints.nary.knapsack.structure.WeightInterface;

public class BinarySearchFingerTree
extends FingerTree<InnerNode, KPItem> {
    public BinarySearchFingerTree(List<KPItem> sortedItems, Supplier<InnerNode> supplier) {
        super(sortedItems);
        this.setupTree(supplier);
    }

    public BinarySearchFingerTree(int[] sortedWeights, int[] sortedEnergy, Supplier<InnerNode> supplier) {
        ArrayList<KPItem> sortedList = new ArrayList<KPItem>();
        for (int i = 0; i < sortedEnergy.length; ++i) {
            sortedList.set(i, new KPItem(sortedEnergy[i], sortedWeights[i]));
        }
        this.init(sortedList);
    }

    private WeightInterface getNodeWeightInterface(int index) {
        if (this.isLeaf(index)) {
            return (WeightInterface)this.getLeaf(index);
        }
        if (this.isInnerNode(index)) {
            return (WeightInterface)this.getInnerNode(index);
        }
        throw new IndexOutOfBoundsException("Looking for an index that corresponds to nothing in the tree (leaf outside of range)");
    }

    public int getNodeWeight(int index) {
        if (this.isInnerNode(index) || this.isLeaf(index)) {
            return this.getNodeWeightInterface(index).getWeight();
        }
        return -1;
    }

    private void setupTree(Supplier<InnerNode> supplier) {
        int i;
        int innerNodeSize = this.getInnerNodeTreeList().size();
        for (i = 0; i < innerNodeSize; ++i) {
            this.getInnerNodeTreeList().set(i, supplier.get());
        }
        for (i = 0; i < this.getLeafTreeList().size(); ++i) {
            ((InnerNode)this.getInnerNode(this.getLeafParentIndex(i))).updateValue((KPItem)this.getLeaf(innerNodeSize + i));
        }
        for (i = innerNodeSize - 1; i > 0; --i) {
            ((InnerNode)this.getInnerNode(this.getParentIndex(i))).updateValue((InnerNode)this.getInnerNode(i));
        }
    }

    public void removeLeaf(int leafIndex) {
        ((KPItem)this.getLeaf(leafIndex)).desactivate();
        this.updateTree(leafIndex);
    }

    public void activateLeaf(int leafIndex) {
        ((KPItem)this.getLeaf(leafIndex)).activate();
        this.updateTree(leafIndex);
    }

    private void updateTree(int leafIndex) {
        int index = this.getLeafParentIndex(leafIndex, false);
        ((InnerNode)this.getInnerNode(index)).setup();
        ((InnerNode)this.getInnerNode(index)).updateValue((KPItem)this.getLeaf(leafIndex));
        if (this.getBrother(leafIndex) != leafIndex) {
            ((InnerNode)this.getInnerNode(index)).updateValue((KPItem)this.getLeaf(this.getBrother(leafIndex)));
        }
        while (index > 0) {
            int parentIndex = this.getParentIndex(index);
            if (this.getBrother(index) != index) {
                ((InnerNode)this.getInnerNode(parentIndex)).setValue((InnerNode)this.getInnerNode(index), (InnerNode)this.getInnerNode(this.getBrother(index)));
            } else {
                ((InnerNode)this.getInnerNode(parentIndex)).setup();
                ((InnerNode)this.getInnerNode(parentIndex)).updateValue((InnerNode)this.getInnerNode(index));
            }
            index = parentIndex;
        }
    }

    private int minLeafIndexFromInnerNode(int indexNode) {
        int minIdx = indexNode;
        while (this.isInnerNode(minIdx)) {
            minIdx = this.getLeftChild(minIdx);
        }
        return minIdx;
    }

    private int maxLeafIndexFromInnerNode(int indexNode) {
        int maxIdx = indexNode;
        while (this.isInnerNode(maxIdx)) {
            if (!this.isInnerNode(maxIdx = this.getRightChild(maxIdx)) || ((InnerNode)this.getInnerNode(maxIdx)).isActive()) continue;
            maxIdx = this.getBrother(maxIdx);
        }
        return maxIdx;
    }

    public int binarySearch(int startIndex, int boundIndex, Predicate<Integer> predicate, boolean right) {
        assert (this.isLeaf(startIndex));
        int index = startIndex;
        boolean comingFromRightLeaf = false;
        boolean descending = false;
        while ((index != 0 || predicate.test(index)) && (index == startIndex || this.isInnerNode(index) || !predicate.test(index)) && (right ? this.minLeafIndexFromInnerNode(index) <= boundIndex : this.maxLeafIndexFromInnerNode(index) >= boundIndex)) {
            int childIndex;
            if (descending) {
                int secondIndex;
                int firstIndex = right ? this.getLeftChild(index) : this.getRightChild(index);
                int n = secondIndex = right ? this.getRightChild(index) : this.getLeftChild(index);
                if (predicate.test(firstIndex)) {
                    index = firstIndex;
                    continue;
                }
                index = secondIndex;
                continue;
            }
            int n = childIndex = right ? this.getRightChild(index) : this.getLeftChild(index);
            if (predicate.test(index) && this.isInnerNode(index)) {
                if (right != comingFromRightLeaf && predicate.test(childIndex)) {
                    index = childIndex;
                    descending = true;
                    continue;
                }
                if (index == 0) {
                    return -1;
                }
                comingFromRightLeaf = index % 2 == 0;
                index = this.getParentIndex(index);
                continue;
            }
            comingFromRightLeaf = index % 2 == 0;
            index = this.getParentIndex(index);
        }
        if (this.isLeaf(index) && (right ? index <= boundIndex : index >= boundIndex)) {
            return index;
        }
        return -1;
    }

    public String toString() {
        int i;
        String str = "digraph fingertree{\n";
        for (i = 0; i < this.getInnerNodeTreeList().size(); ++i) {
            str = str + "" + i + " [label=\"" + i + this.getInnerNode(i) + "\"];\n";
            if (i == 0) continue;
            str = str + "" + this.getParentIndex(i) + "->" + i + ";\n";
        }
        for (i = 0; i < this.getLeafTreeList().size(); ++i) {
            str = str + "leaf" + i + " [label=\"" + this.leafToGlobalIndex(i) + "w=" + ((KPItem)this.getLeafTreeList().get(i)).getWeight() + ",p=" + ((KPItem)this.getLeafTreeList().get(i)).getProfit() + "\"];\n";
            str = str + "" + this.getLeafParentIndex(i) + "-> leaf" + i + ";\n";
        }
        str = str + "}";
        return str;
    }

    public void createDotFile(String filename) {
        try (FileWriter fWriter = new FileWriter(filename);){
            fWriter.write(this.toString());
        }
        catch (Exception e) {
            System.err.println("Error trying to create DOT file : ");
            e.printStackTrace();
        }
    }
}

