/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.knapsack.structure;

import org.chocosolver.solver.constraints.nary.knapsack.structure.InnerNode;
import org.chocosolver.solver.constraints.nary.knapsack.structure.KPItem;
import org.chocosolver.solver.constraints.nary.knapsack.structure.ProfitInterface;

public class InnerNodeSum
implements InnerNode,
ProfitInterface {
    private int sumWeight;
    private int sumProfit;

    public InnerNodeSum() {
        this.setup();
    }

    @Override
    public void setup() {
        this.sumWeight = 0;
        this.sumProfit = 0;
    }

    @Override
    public void updateValue(KPItem item) {
        if (item.isActive()) {
            this.sumWeight += item.getWeight();
            this.sumProfit += item.getProfit();
        }
    }

    @Override
    public int getWeight() {
        return this.sumWeight;
    }

    @Override
    public int getProfit() {
        return this.sumProfit;
    }

    @Override
    public void updateValue(InnerNode node) {
        try {
            InnerNodeSum nodeSum = (InnerNodeSum)node;
            this.sumWeight += nodeSum.getWeight();
            this.sumProfit += nodeSum.getProfit();
        }
        catch (Exception e) {
            throw new RuntimeException("updateValue of InnerNode used with another type ");
        }
    }

    @Override
    public boolean isActive() {
        return this.sumProfit != 0 || this.sumWeight != 0;
    }

    public String toString() {
        return "w=" + this.sumWeight + ",p=" + this.sumProfit;
    }
}

