/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBoolMax
extends Propagator<BoolVar> {
    private final int n;
    private final int[] lits;

    public PropBoolMax(BoolVar[] variables, BoolVar maxVar) {
        super((Variable[])ArrayUtils.concat(variables, maxVar), (Priority)PropagatorPriority.UNARY, true);
        this.n = variables.length;
        this.lits = new int[]{this.n - 1, 0};
        assert (this.n > 0);
    }

    private void find(int l) throws ContradictionException {
        int last = this.lits[l];
        int otl = this.lits[1 - l];
        int last_cache = last;
        do {
            if (++last >= this.n) {
                last = 0;
            }
            if (otl == last || ((BoolVar[])this.vars)[last].isInstantiated() && !((BoolVar[])this.vars)[last].isInstantiatedTo(1)) continue;
            this.lits[l] = last;
            return;
        } while (last != last_cache);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (((BoolVar[])this.vars)[this.n].isInstantiatedTo(0)) {
            for (int i = 0; i < this.n; ++i) {
                ((BoolVar[])this.vars)[i].instantiateTo(0, (ICause)this);
            }
            return;
        }
        for (int i = 0; i < this.n; ++i) {
            if (!((BoolVar[])this.vars)[i].isInstantiatedTo(1)) continue;
            ((BoolVar[])this.vars)[this.n].instantiateTo(1, (ICause)this);
            if (!((BoolVar[])this.vars)[this.n].isInstantiatedTo(1)) continue;
            this.setPassive();
            return;
        }
        this.find(0);
        this.find(1);
        this.filter();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == this.n) {
            if (((BoolVar[])this.vars)[this.lits[0]].isInstantiated()) {
                this.find(0);
            }
            if (((BoolVar[])this.vars)[this.lits[1]].isInstantiated()) {
                this.find(1);
            }
            this.filter();
        } else if (((BoolVar[])this.vars)[idxVarInProp].isInstantiatedTo(1)) {
            ((BoolVar[])this.vars)[this.n].instantiateTo(1, (ICause)this);
            if (((BoolVar[])this.vars)[this.n].isInstantiatedTo(1)) {
                this.setPassive();
            }
        } else if (idxVarInProp == this.lits[0]) {
            this.find(0);
            if (((BoolVar[])this.vars)[this.lits[1]].isInstantiated()) {
                this.find(1);
            }
            this.filter();
        } else if (idxVarInProp == this.lits[1]) {
            this.find(1);
            if (((BoolVar[])this.vars)[this.lits[0]].isInstantiated()) {
                this.find(0);
            }
            this.filter();
        }
    }

    public void filter() throws ContradictionException {
        int bn;
        int l0 = this.lits[0];
        int l1 = this.lits[1];
        int b1 = ((BoolVar[])this.vars)[l0].isInstantiated() ? ((BoolVar[])this.vars)[l0].getValue() : 2;
        int b2 = ((BoolVar[])this.vars)[l1].isInstantiated() ? ((BoolVar[])this.vars)[l1].getValue() : 2;
        int n = bn = ((BoolVar[])this.vars)[this.n].isInstantiated() ? ((BoolVar[])this.vars)[this.n].getValue() : 2;
        if (bn == 0) {
            for (int i = 0; i < this.n; ++i) {
                ((BoolVar[])this.vars)[i].instantiateTo(0, (ICause)this);
            }
        } else if (b1 == 0 && b2 == 0) {
            ((BoolVar[])this.vars)[this.n].instantiateTo(0, (ICause)this);
            if (!this.isPassive()) {
                this.setPassive();
            }
        } else if (bn == 1) {
            if (b1 == 0) {
                ((BoolVar[])this.vars)[l1].instantiateTo(1, (ICause)this);
            } else if (b2 == 0) {
                ((BoolVar[])this.vars)[l0].instantiateTo(1, (ICause)this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int ub = ((BoolVar[])this.vars)[this.n].getUB();
        for (i = 0; i < this.n; ++i) {
            if (((BoolVar[])this.vars)[i].getLB() <= ub) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.n; ++i) {
            if (((BoolVar[])this.vars)[i].getUB() <= ub) continue;
            return ESat.UNDEFINED;
        }
        if (((BoolVar[])this.vars)[this.n].isInstantiated()) {
            for (i = 0; i < this.n; ++i) {
                if (!((BoolVar[])this.vars)[i].isInstantiatedTo(ub)) continue;
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((BoolVar[])this.vars)[this.n]).append(" = max(");
        sb.append(((BoolVar[])this.vars)[0]);
        for (int i = 1; i < this.n; ++i) {
            sb.append(", ");
            sb.append(((BoolVar[])this.vars)[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

